/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class BasicMiscEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BasicMiscEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isPushable() {
        return this.isAlive();
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            double gravity = -0.08;
            FluidType submergedFluid = this.getEyeInFluidType();
            if (submergedFluid != NeoForgeMod.EMPTY_TYPE.value()) {
                gravity *= this.getFluidMotionScale(submergedFluid);
            }
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, gravity, 0.0));
        }
        BlockPos feetPos = this.getBlockPosBelowThatAffectsMyMovement();
        float blockFriction = this.onGround() ? this.level().getBlockState(feetPos).getFriction((LevelReader)this.level(), feetPos, (Entity)this) * 0.91f : 0.91f;
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)blockFriction, 0.98, (double)blockFriction));
        if (this.getDeltaMovement().lengthSqr() != 0.0) {
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

