/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task.temp;

import java.util.function.BiPredicate;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowParent;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class FixedFollowParent<E extends AgeableMob>
extends FollowParent<E> {
    private BiPredicate<E, AgeableMob> parentPredicate = (entity, other) -> entity.getClass() == other.getClass() && other.getAge() >= 0;

    public FixedFollowParent<E> parentPredicate(BiPredicate<E, AgeableMob> predicate) {
        this.parentPredicate = predicate;
        return this;
    }

    @Nullable
    protected AgeableMob getParent(E entity) {
        return ((NearestVisibleLivingEntities)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).findClosest(other -> {
            AgeableMob ageableMob;
            return other instanceof AgeableMob && this.parentPredicate.test(entity, ageableMob = (AgeableMob)other);
        }).map(AgeableMob.class::cast).orElse(null);
    }
}

