/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class ParryStunlockTask<E extends Mob>
extends Behavior<E> {
    private int lastHitTime = 0;
    private int stunCount = 0;
    private int blockTime = 0;

    public ParryStunlockTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryStatus.VALUE_PRESENT), 200);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        int lastHitTime = owner.getLastHurtByMobTimestamp();
        return lastHitTime != 0 && lastHitTime >= ((Mob)owner).tickCount - 60;
    }

    protected void start(ServerLevel level, E owner, long gameTime) {
        this.lastHitTime = owner.getLastHurtByMobTimestamp();
        this.stunCount = 1;
    }

    protected void tick(ServerLevel level, E owner, long gameTime) {
        if (owner.isBlocking()) {
            ++this.blockTime;
            LivingEntity target = owner.getLastHurtByMob();
            if (this.blockTime >= 5) {
                if (!owner.getBrain().hasMemoryValue(MemoryModuleType.LOOK_TARGET)) {
                    BehaviorUtils.lookAtEntity(owner, (LivingEntity)target);
                }
                if (owner.isWithinMeleeAttackRange(target)) {
                    owner.swing(InteractionHand.MAIN_HAND);
                    owner.doHurtTarget((Entity)target);
                    this.doStop(level, (LivingEntity)owner, gameTime);
                } else if (owner.onGround()) {
                    Vec3 lungeVector = new Vec3(target.getX() - owner.getX(), 0.0, target.getZ() - owner.getZ());
                    if (lungeVector.lengthSqr() > 1.0E-7) {
                        lungeVector = lungeVector.normalize().scale(0.4);
                    }
                    owner.setDeltaMovement(lungeVector.x(), (double)0.1f, lungeVector.z());
                }
            }
            return;
        }
        if (this.lastHitTime != owner.getLastHurtByMobTimestamp()) {
            this.lastHitTime = owner.getLastHurtByMobTimestamp();
            ++this.stunCount;
        }
        if (this.stunCount > 2) {
            if (!(owner.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof ShieldItem)) {
                owner.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.SHIELD));
            }
            owner.startUsingItem(InteractionHand.OFF_HAND);
        }
    }

    protected boolean canStillUse(ServerLevel pLevel, E owner, long pGameTime) {
        return this.lastHitTime > ((Mob)owner).tickCount - 60 && owner.getLastHurtByMob() != null;
    }

    protected void stop(ServerLevel pLevel, E owner, long pGameTime) {
        this.stunCount = 0;
        this.lastHitTime = 0;
        this.blockTime = 0;
        if (owner.isUsingItem()) {
            owner.stopUsingItem();
        }
    }
}

