/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss.tyrosaur;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoAFluidTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class WoundedTyrosaurEntity
extends AoAMeleeMob<WoundedTyrosaurEntity> {
    public WoundedTyrosaurEntity(EntityType<? extends WoundedTyrosaurEntity> entityType, Level level) {
        super((EntityType<? extends AoAMeleeMob>)entityType, level);
        this.setParts(new AoAEntityPart<WoundedTyrosaurEntity>(this, 0.875f, this.getBbHeight() - 0.625f, 0.0f, 0.5f, -this.getBbWidth() * 0.5f - 0.4375f), new AoAEntityPart<WoundedTyrosaurEntity>(this, 0.5625f, 0.5625f, 0.0f, 0.4375f, -this.getBbWidth() * 1.35f).setDamageMultiplier(0.85f), new AoAEntityPart<WoundedTyrosaurEntity>(this, 0.5625f, 0.5625f, 0.0f, 0.375f, -this.getBbWidth() * 1.75f).setDamageMultiplier(0.85f), new AoAEntityPart<WoundedTyrosaurEntity>(this, 0.875f, this.getBbHeight() - 0.625f, 0.0f, 0.5f, this.getBbWidth() * 0.5f + 0.4375f), new AoAEntityPart<WoundedTyrosaurEntity>(this, 0.6875f, 1.0f, 0.0f, 0.5f, this.getBbWidth() * 1.4f));
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_TYROSAUR_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_TYROSAUR_HURT.get();
    }

    @Override
    protected float getStepWeight() {
        return 3.0f;
    }

    @Override
    protected boolean isQuadruped() {
        return true;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setHealth((float)RandomUtil.randomValueBetween((double)0.06f, (double)0.08f) * this.getMaxHealth());
        return spawnGroupData;
    }

    @Override
    public void die(DamageSource source) {
        super.die(source);
        LivingEntity livingEntity = this.getKillCredit();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)livingEntity;
            InventoryUtil.findItem((Player)pl, stack -> stack.is(AoAItems.BONE_HORN) && stack.isDamaged() && stack.getDamageValue() == 1).ifPresent(pair -> ((ItemStack)pair.right()).setDamageValue(0));
        }
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (damageContainer.getSource().is(DamageTypeTags.IS_FIRE) && this.level().getFluidState(BlockPos.containing((Position)this.getEyePosition())).getFluidType() == AoAFluidTypes.TAR.get() && this.level().getFluidState(this.blockPosition().above()).getFluidType() == AoAFluidTypes.TAR.get()) {
                ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.LARGE_SMOKE, (Entity)this).colourOverride(0xFFFFFF).spawnNTimes(20).sendToAllPlayersTrackingEntity(level2, (Entity)this);
                if (this.isDeadOrDying()) {
                    AoAScheduler.scheduleSyncronisedTask(() -> EntitySpawningUtil.spawnEntity(level2, (EntityType)AoAMonsters.SKELETRON.get(), this.position(), MobSpawnType.CONVERSION, abomination -> {
                        abomination.setXRot(this.getXRot());
                        abomination.setYRot(this.getYRot());
                        abomination.setYHeadRot(this.getYHeadRot());
                    }), 19 - this.deathTime);
                }
            }
        }
    }

    @Override
    protected int getPreAttackTime() {
        return 5;
    }

    @Override
    public int getCurrentSwingDuration() {
        return 11;
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<WoundedTyrosaurEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(635.0).moveSpeed(0.2).meleeStrength(15.0).knockbackResist(0.9).followRange(100.0).aggroRange(64.0).armour(10.0, 10.0).knockback(1.0).stepHeight(1.25);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_BITE).transitionLength(0));
    }
}

