/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss.tyrosaur;

import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.ScreenShakePacket;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.content.entity.ai.mob.AnimatableMeleeAttack;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.entity.boss.ArmouredBoss;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyLivingEntitySensor;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.content.entity.misc.EarthquakeBlockEntity;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.integration.tes.TESIntegration;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.MathUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.api.particle.transitionworker.AwayFromPositionParticleTransition;
import net.tslat.effectslib.api.particle.transitionworker.ParticleTransitionWorker;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.HeldBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.ReactToUnreachableTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class TyrosaurEntity
extends AoABoss
implements ArmouredBoss {
    private static final float ARMOUR_MODIFIER = 60.0f;
    private static final float MAX_ARMOUR = 600.0f;
    public static final EntityDataHolder<Float> ARMOUR = EntityDataHolder.register(TyrosaurEntity.class, EntityDataSerializers.FLOAT, Float.valueOf(600.0f), tyrosaur -> Float.valueOf(tyrosaur.armour), (tyrosaur, value) -> {
        tyrosaur.armour = value.floatValue();
    });
    private static final RawAnimation ROAR_START_ANIM = RawAnimation.begin().thenPlay("misc.roar.start");
    private static final RawAnimation ROAR_ANIM = RawAnimation.begin().thenPlay("misc.roar.hold");
    private static final RawAnimation ROAR_STOP_ANIM = RawAnimation.begin().thenPlay("misc.roar.stop");
    private static final int BITE = 0;
    private static final int HORN = 1;
    private static final int SLAM = 2;
    private static final int ROAR = 3;
    private float armour = 600.0f;

    public TyrosaurEntity(EntityType<? extends TyrosaurEntity> entityType, Level level) {
        super((EntityType<? extends AoABoss>)entityType, level);
        this.setParts(new AoAEntityPart<TyrosaurEntity>(this, 0.875f, this.getBbHeight() - 0.625f, 0.0f, 0.5f, -this.getBbWidth() * 0.5f - 0.4375f), new AoAEntityPart<TyrosaurEntity>(this, 0.5625f, 0.5625f, 0.0f, 0.4375f, -this.getBbWidth() * 1.35f).setDamageMultiplier(0.85f), new AoAEntityPart<TyrosaurEntity>(this, 0.5625f, 0.5625f, 0.0f, 0.375f, -this.getBbWidth() * 1.75f).setDamageMultiplier(0.85f), new AoAEntityPart<TyrosaurEntity>(this, 0.875f, this.getBbHeight() - 0.625f, 0.0f, 0.5f, this.getBbWidth() * 0.5f + 0.4375f), new AoAEntityPart<TyrosaurEntity>(this, 0.6875f, 1.0f, 0.0f, 0.5f, this.getBbWidth() * 1.4f), new AoAEntityPart<TyrosaurEntity>(this, 1.0f, this.getBbHeight() - 0.75f, 0.0f, this.getBbHeight() - 0.25f, this.getBbWidth() * 0.5f + 0.125f){

            @Override
            public boolean hurt(DamageSource source, float amount) {
                if (!DamageUtil.isMeleeDamage(source)) {
                    return false;
                }
                return super.hurt(source, amount);
            }

            public ProjectileDeflection deflection(Projectile projectile) {
                return (projectile2, entity, random) -> {
                    Vec3 vec3 = projectile2.getDeltaMovement().cross(MathUtil.getEyelineForward((Entity)TyrosaurEntity.this)).add(0.0, (double)0.4f, 0.0).normalize();
                    projectile2.setDeltaMovement(vec3);
                    projectile2.hasImpulse = true;
                };
            }
        });
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, ARMOUR);
    }

    @Override
    protected void addSwingData(AoABoss.SwingData swings) {
        swings.put(0, new AoABoss.SwingData.Swing(11, 5, DefaultAnimations.ATTACK_BITE));
        swings.put(1, new AoABoss.SwingData.Swing(13, 6, DefaultAnimations.ATTACK_THROW));
    }

    @Override
    @Nullable
    public SoundEvent getMusic() {
        return (SoundEvent)AoASounds.TYROSAUR_MUSIC.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_TYROSAUR_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_TYROSAUR_HURT.get();
    }

    @Override
    protected float getStepWeight() {
        return 4.0f;
    }

    @Override
    protected boolean isQuadruped() {
        return true;
    }

    @Override
    protected int getPreAttackTime() {
        return this.getSwingWarmupTicks();
    }

    @Override
    protected int getAttackSwingDuration() {
        return this.getSwingDurationTicks();
    }

    @Override
    public float getArmourPercent() {
        return Mth.clamp((float)(ARMOUR.get((Entity)this).floatValue() / 600.0f), (float)0.0f, (float)1.0f);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.updateArmour(this.getArmourPercent() * 600.0f);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public List<ExtendedSensor<? extends AoABoss>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new AggroBasedNearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).getOwnerUUID() != null;
        }).setScanRate(entity -> 40), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<? extends AoABoss> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(1.25f)), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new ReactToUnreachableTarget().timeBeforeReacting(entity -> 80).reaction((entity, isTowering) -> BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()))).cooldownFor(entity -> 80), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new AnimatableMeleeAttack(this.getSwingWarmupTicks(0)).attackInterval(entity -> this.getSwingDurationTicks(0) + 2).whenStarting(entity -> ATTACK_STATE.set((Entity)entity, 0)), (Object)30), Pair.of((Object)new AnimatableMeleeAttack<Mob>(this.getSwingWarmupTicks(1)).attackEffect((entity, target) -> {
            target.setDeltaMovement(MathUtil.getEyelineForward((Entity)entity).scale(-0.75).add(0.0, 1.5, 0.0));
            EntityUtil.applyPotions((Entity)target, new EffectBuilder(AoAMobEffects.BLEEDING, 200));
        }).attackInterval(entity -> this.getSwingDurationTicks(1) + 2).whenStarting(entity -> ATTACK_STATE.set((Entity)entity, 1)), (Object)5), Pair.of((Object)new Roar().startCondition(entity -> !BrainUtils.isOnSpecialCooldown((LivingEntity)entity)).runFor(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE) ? entity.random.nextInt(160, 200) : entity.random.nextInt(100, 200)).cooldownFor(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE) ? entity.random.nextInt(80, 140) : entity.random.nextInt(400, 800)).whenStopping(entity -> BrainUtils.setSpecialCooldown((LivingEntity)entity, (int)150)), (Object)1), Pair.of((Object)new Earthquake().startCondition(entity -> !BrainUtils.isOnSpecialCooldown((LivingEntity)entity) && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.TARGET_UNREACHABLE.get()))).cooldownFor(entity -> entity.random.nextInt(200, 400)).whenStopping(entity -> BrainUtils.setSpecialCooldown((LivingEntity)entity, (int)100)), (Object)3)})})});
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (ARMOUR.get((Entity)this).floatValue() > 0.0f && !this.level().isClientSide && !DamageUtil.isEnvironmentalDamage(source)) {
            float armourDamage = amount;
            if (source.is(DamageTypeTags.IS_PROJECTILE) && !DamageUtil.isMagicDamage(source) && !source.is(AoADamageTypes.HEAVY_GUN)) {
                armourDamage *= 0.25f;
            }
            if (!source.is(DamageTypeTags.BYPASSES_ARMOR)) {
                Entity entity;
                if (DamageUtil.isMeleeDamage(source) && (entity = source.getDirectEntity()) instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    ItemStack weapon = attacker.getMainHandItem();
                    armourDamage = weapon.canPerformAction(ItemAbilities.PICKAXE_DIG) ? (armourDamage *= 1.0f + weapon.getDestroySpeed(Blocks.STONE.defaultBlockState()) * 0.075f + (float)attacker.getAttributeValue(Attributes.MINING_EFFICIENCY) * 0.04f) : (armourDamage *= 0.5f);
                } else if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                    armourDamage *= 1.25f;
                }
                if (IntegrationManager.isTESActive()) {
                    TESIntegration.sendParticle((LivingEntity)this, armourDamage, -5592406);
                }
                this.updateArmour(ARMOUR.get((Entity)this).floatValue() - armourDamage);
            }
        }
        return super.hurt(source, amount);
    }

    private void updateArmour(float newArmour) {
        newArmour = Mth.clamp((float)newArmour, (float)0.0f, (float)600.0f);
        int oldArmourStage = Mth.ceil((float)(ARMOUR.get((Entity)this).floatValue() / 600.0f * 4.0f));
        int newArmourStage = Mth.ceil((float)(newArmour / 600.0f * 4.0f));
        ARMOUR.set((Entity)this, Float.valueOf(newArmour));
        float armourPercent = this.getArmourPercent();
        AttributeUtil.applyTransientModifier((LivingEntity)this, (Holder<Attribute>)Attributes.ARMOR, TyrosaurEntity.getArmourMod(armourPercent));
        AttributeUtil.applyTransientModifier((LivingEntity)this, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, TyrosaurEntity.getArmourToughnessMod(armourPercent));
        if (oldArmourStage != newArmourStage) {
            new SoundBuilder((Holder<SoundEvent>)AoASounds.STONE_CRUMBLE).followEntity((Entity)this).execute();
            ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.DUST_PLUME, (Entity)this).lifespan(20).colourOverride(0.5f, 0.5f, 0.5f, 1.0f).spawnNTimes(20).addTransition((ParticleTransitionWorker)AwayFromPositionParticleTransition.create((Vec3)this.position().add(0.0, (double)(this.getBbHeight() * 0.5f), 0.0), (int)10)).sendToAllPlayersTrackingEntity((ServerLevel)this.level(), (Entity)this);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("ArmourPercent", this.getArmourPercent());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("ArmourPercent", 5)) {
            this.updateArmour(compound.getFloat("ArmourPercent") * 600.0f);
        }
    }

    protected AABB getAttackBoundingBox() {
        AABB boundingBox = this.getBoundingBox();
        if (this.getVehicle() != null) {
            AABB vehicleBounds = this.getVehicle().getBoundingBox();
            boundingBox = new AABB(Math.min(boundingBox.minX, vehicleBounds.minX), boundingBox.minY, Math.min(boundingBox.minZ, vehicleBounds.minZ), Math.max(boundingBox.maxX, vehicleBounds.maxX), boundingBox.maxY, Math.max(boundingBox.maxZ, vehicleBounds.maxZ));
        }
        return boundingBox.inflate((double)1.65f, 0.0, (double)1.65f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<TyrosaurEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(635.0).moveSpeed(0.2875f).meleeStrength(15.0).knockbackResist(0.9).followRange(100.0).aggroRange(64.0).armour(10.0, 15.0).knockback(1.0).stepHeight(1.25);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Main", 0, state -> {
            if (ATTACK_STATE.is((Entity)this, 3)) {
                return state.setAndContinue(ROAR_ANIM);
            }
            if (state.isMoving()) {
                return state.setAndContinue(this.isSprinting() ? DefaultAnimations.RUN : DefaultAnimations.WALK);
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        }).triggerableAnim("roar_start", ROAR_START_ANIM).triggerableAnim("roar_stop", ROAR_STOP_ANIM).triggerableAnim("slam", DefaultAnimations.ATTACK_SLAM));
        controllers.add(new AnimationController((GeoAnimatable)this, "Attack", 0, state -> {
            if (this.swinging) {
                return state.setAndContinue(this.getSwingAnimation());
            }
            state.resetCurrentAnimation();
            return PlayState.STOP;
        }));
    }

    private static AttributeModifier getArmourMod(float percent) {
        return new AttributeModifier(AdventOfAscension.id("tyrosaur_armour"), (double)(60.0f * percent), AttributeModifier.Operation.ADD_VALUE);
    }

    private static AttributeModifier getArmourToughnessMod(float percent) {
        return new AttributeModifier(AdventOfAscension.id("tyrosaur_armour_toughness"), (double)(60.0f * percent), AttributeModifier.Operation.ADD_VALUE);
    }

    private static class Roar
    extends HeldBehaviour<TyrosaurEntity> {
        private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT)});
        private int roarSoundDelay = 0;

        private Roar() {
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
        }

        protected void start(TyrosaurEntity entity) {
            new SoundBuilder((Holder<SoundEvent>)AoASounds.ENTITY_TYROSAUR_ROAR_START).radius(32.0f).followEntity((Entity)entity.getParts()[4]).execute();
            this.roarSoundDelay = entity.random.nextInt(4, 8);
            AoAMonster.ATTACK_STATE.set((Entity)entity, 3);
            entity.setImmobile(true);
            entity.triggerAnim("Main", "roar_start");
        }

        protected boolean shouldKeepRunning(TyrosaurEntity entity) {
            return BrainUtils.getTargetOfEntity((LivingEntity)entity) != null;
        }

        protected void tick(TyrosaurEntity entity) {
            if (this.runningTime > 30 && this.runningTime % this.roarSoundDelay == 0) {
                this.roarSoundDelay = entity.random.nextInt(5, 7);
                new SoundBuilder((Holder<SoundEvent>)AoASounds.ENTITY_TYROSAUR_ROAR_LOOP).radius(32.0f).followEntity((Entity)entity.getParts()[4]).execute();
            }
            if (this.runningTime > 33 && entity.tickCount % 2 == 0) {
                ServerLevel level = (ServerLevel)entity.level();
                Vec3 forward = MathUtil.getBodyForward((LivingEntity)entity);
                Vec3 pos = entity.getEyePosition().add(forward.scale((double)(entity.getBbWidth() * 1.4f - 0.3f)));
                TELParticlePacket packet = new TELParticlePacket();
                if (entity.tickCount % 6 == 0) {
                    packet.particle(ParticleBuilder.forPositionsInCircle((ParticleOptions)((ParticleOptions)AoAParticleTypes.ORB.get()), (Vec3)pos, (Vec3)forward, (double)0.25, (int)32).lifespan(20).scaleMod(0.4f).colourOverride(1.0f, 1.0f, 1.0f, 0.5f).addTransition((ParticleTransitionWorker)AwayFromPositionParticleTransition.create((Vec3)pos.subtract(forward.scale(0.25)), (int)3)));
                } else if (entity.tickCount % 8 == 0) {
                    packet.particle(ParticleBuilder.forPositionsInCircle((ParticleOptions)((ParticleOptions)AoAParticleTypes.ORB.get()), (Vec3)pos, (Vec3)forward, (double)0.25, (int)32).lifespan(20).scaleMod(0.4f).colourOverride(1.0f, 1.0f, 1.0f, 0.5f).addTransition((ParticleTransitionWorker)AwayFromPositionParticleTransition.create((Vec3)pos.subtract(forward.scale((double)0.1f)), (int)3)));
                } else {
                    packet.particle(ParticleBuilder.forRandomPosInSphere((ParticleOptions)ParticleTypes.DUST_PLUME, (Vec3)entity.getEyePosition(), (double)0.05f).lifespan(20).spawnNTimes(20).addTransition((ParticleTransitionWorker)AwayFromPositionParticleTransition.create((Vec3)entity.getEyePosition(), (int)10)));
                }
                packet.sendToAllPlayersTrackingEntity(level, (Entity)entity);
                if (entity.tickCount % 10 == 0) {
                    for (LivingEntity target2 : EntityRetrievalUtil.getEntities((Level)level, (AABB)entity.getBoundingBox().inflate(32.0), target -> target instanceof LivingEntity && target != entity)) {
                        float strength = Math.max(0.2f, 1.0f - (float)entity.distanceToSqr((Entity)target2) / 300.0f);
                        float hearingMod = (float)(target2.getViewVector(1.0f).normalize().dot(target2.getEyePosition().vectorTo(entity.getEyePosition()).normalize()) + 1.0) * 0.5f;
                        if (target2.isCrouching()) {
                            hearingMod -= 0.25f;
                        }
                        if (!DamageUtil.doMiscEnergyAttack((Entity)entity, (Entity)target2, (strength *= 1.0f + hearingMod) * 2.0f, entity.position())) continue;
                        if (hearingMod > 0.5f) {
                            EntityUtil.applyPotions((Entity)target2, new EffectBuilder(MobEffects.DIG_SLOWDOWN, 200).isAmbient());
                            if (hearingMod > 0.8f && !target2.hasEffect(MobEffects.WEAKNESS)) {
                                EntityUtil.applyPotions((Entity)target2, new EffectBuilder(MobEffects.WEAKNESS, 200).isAmbient());
                            }
                        }
                        if (!(target2 instanceof ServerPlayer)) continue;
                        ServerPlayer pl = (ServerPlayer)target2;
                        AoANetworking.sendToPlayer(pl, new ScreenShakePacket(20.0, strength * 1.5f, 0.98f));
                    }
                }
            }
        }

        protected void stop(TyrosaurEntity entity) {
            AoAScheduler.scheduleSyncronisedTask(() -> new SoundBuilder((Holder<SoundEvent>)AoASounds.ENTITY_TYROSAUR_ROAR_STOP).followEntity((Entity)entity).execute(), 3);
            AoAMonster.ATTACK_STATE.set((Entity)entity, 0);
            entity.setImmobile(false);
            entity.triggerAnim("Main", "roar_stop");
        }
    }

    private static class Earthquake
    extends DelayedBehaviour<TyrosaurEntity> {
        private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT)});

        public Earthquake() {
            super(25);
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
        }

        protected void start(TyrosaurEntity entity) {
            AoAMonster.ATTACK_STATE.set((Entity)entity, 2);
            entity.triggerAnim("Main", "slam");
            entity.setImmobile(true);
        }

        protected void doDelayedAction(TyrosaurEntity entity) {
            ServerLevel level = (ServerLevel)entity.level();
            Vec3 stompPos = entity.position().add(MathUtil.getBodyForward((LivingEntity)entity).scale((double)1.35f));
            this.doFX(entity, stompPos);
            Vec3 earthquakeOrigin = stompPos.subtract(0.0, 1.0, 0.0);
            AoAScheduler.scheduleSyncronisedTask(() -> {
                for (ServerPlayer player : level.players()) {
                    if (player.distanceToSqr((Entity)entity) > 400.0) continue;
                    AoANetworking.sendToPlayer(player, new ScreenShakePacket(10.0, Math.max(0.1f, (1.0f - (float)earthquakeOrigin.distanceToSqr(player.position()) / 400.0f) * 2.0f), 0.98f));
                }
            }, 3);
            for (int i = 0; i < 20; ++i) {
                int tick = i;
                AoAScheduler.scheduleSyncronisedTask(() -> {
                    Set positions;
                    try (BulkSectionAccess access = new BulkSectionAccess((LevelAccessor)level);){
                        positions = ((Stream)Streams.stream(MathUtil.inLateralCircle(earthquakeOrigin, tick, 64.0)).unordered()).map(BlockPos::containing).distinct().map(pos -> {
                            BlockState state = access.getBlockState(pos);
                            if (!state.blocksMotion()) {
                                int offset = 10;
                                while (offset-- > 0 && !(state = access.getBlockState(pos = pos.below())).blocksMotion()) {
                                }
                            } else if (access.getBlockState(pos.above()).blocksMotion()) {
                                int offset = 10;
                                while (offset-- > 0 && access.getBlockState(pos = pos.above()).blocksMotion()) {
                                }
                                pos = pos.below();
                                state = access.getBlockState(pos);
                            }
                            return Pair.of((Object)pos, (Object)state);
                        }).filter(pair -> ((BlockState)pair.getSecond()).blocksMotion()).filter(pair -> !access.getBlockState(((BlockPos)pair.getFirst()).above()).blocksMotion()).collect(Collectors.toSet());
                    }
                    TELParticlePacket packet = new TELParticlePacket();
                    if (entity.tickCount % 3 == 0) {
                        for (ServerPlayer player : level.players()) {
                            if (player.distanceToSqr((Entity)entity) > 1024.0) continue;
                            Vec3 velocity = earthquakeOrigin.vectorTo(player.position()).normalize();
                            new SoundBuilder((Holder<SoundEvent>)AoASounds.FX_RUBBLE).isBlocks().atPos((Level)level, earthquakeOrigin.add(velocity.scale((double)tick))).moving(velocity).pitch(0.75f).category(SoundSource.BLOCKS).include(new Player[]{player}).execute();
                        }
                    }
                    for (Pair ringPos : positions) {
                        EarthquakeBlockEntity block = new EarthquakeBlockEntity((EntityType)AoAMiscEntities.EARTHQUAKE_BLOCK.get(), (Level)level, (BlockState)ringPos.getSecond(), (BlockPos)ringPos.getFirst(), (LivingEntity)entity);
                        block.setDamage(8.0f);
                        block.setDeltaMovement(new Vec3(0.0, (double)0.35f, 0.0));
                        block.setPos(Vec3.atCenterOf((Vec3i)((Vec3i)ringPos.getFirst())));
                        level.addFreshEntity((Entity)block);
                        packet.particle(ParticleBuilder.forRandomPosInBlock((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, (BlockState)ringPos.getSecond()), (BlockPos)((BlockPos)ringPos.getFirst())).lifespan(entity.random.nextInt(20, 40)).scaleMod(0.5f).velocity(entity.random.nextGaussian() * (double)0.1f, (double)(entity.random.nextFloat() * 0.2f + 0.2f), entity.random.nextGaussian() * (double)0.1f));
                    }
                    packet.sendToAllPlayersTrackingEntity(level, (Entity)entity);
                }, i + 1);
            }
        }

        private void doFX(TyrosaurEntity entity, Vec3 stompPos) {
            int i;
            Vec3 right = MathUtil.getBodyRight((LivingEntity)entity);
            Vec3 leftFootPos = stompPos.add(right.scale(0.75));
            Vec3 rightFootPos = stompPos.add(right.scale(-0.75));
            BlockState leftFootState = entity.level().getBlockState(BlockPos.containing((double)leftFootPos.x, (double)(leftFootPos.y - (double)0.1f), (double)leftFootPos.z));
            BlockState rightFootState = entity.level().getBlockState(BlockPos.containing((double)rightFootPos.x, (double)(rightFootPos.y - (double)0.1f), (double)rightFootPos.z));
            new SoundBuilder((Holder<SoundEvent>)AoASounds.FX_SLAM).atPos(entity.level(), stompPos).isMonster().radius(32.0f).execute();
            TELParticlePacket packet = new TELParticlePacket();
            if (!leftFootState.isAir()) {
                for (i = 0; i < 20; ++i) {
                    packet.particle(ParticleBuilder.forPositions((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, leftFootState), (Vec3[])new Vec3[]{leftFootPos}).lifespan(entity.random.nextInt(40, 60)).velocity(entity.random.nextGaussian() * (double)0.1f, (double)(entity.random.nextFloat() * 0.3f + 0.2f), entity.random.nextGaussian() * (double)0.1f));
                    if (i >= 5) continue;
                    packet.particle(ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (Vec3[])new Vec3[]{leftFootPos}).colourOverride(1.0f, 1.0f, 1.0f, 0.5f).lifespan(entity.random.nextInt(40, 60)).velocity(entity.random.nextGaussian() * (double)0.05f, (double)entity.random.nextFloat() * 0.1, entity.random.nextGaussian() * (double)0.05f));
                }
            }
            if (!rightFootState.isAir()) {
                for (i = 0; i < 10; ++i) {
                    packet.particle(ParticleBuilder.forPositions((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, rightFootState), (Vec3[])new Vec3[]{rightFootPos}).lifespan(entity.random.nextInt(40, 60)).velocity(entity.random.nextGaussian() * (double)0.1f, (double)(entity.random.nextFloat() * 0.3f + 0.2f), entity.random.nextGaussian() * (double)0.1f));
                    if (i >= 5) continue;
                    packet.particle(ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (Vec3[])new Vec3[]{rightFootPos}).colourOverride(1.0f, 1.0f, 1.0f, 0.5f).lifespan(entity.random.nextInt(40, 60)).velocity(entity.random.nextGaussian() * (double)0.05f, (double)entity.random.nextFloat() * 0.1, entity.random.nextGaussian() * (double)0.05f));
                }
            }
            packet.sendToAllPlayersTrackingEntity((ServerLevel)entity.level(), (Entity)entity);
        }

        protected void stop(TyrosaurEntity entity) {
            AoAMonster.ATTACK_STATE.set((Entity)entity, 0);
            entity.setImmobile(false);
        }
    }
}

