/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss.smash;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.content.entity.brain.task.custom.ChargeAttack;
import net.tslat.aoa3.content.entity.brain.task.custom.GroundSlamAttack;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.ReactToUnreachableTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FleeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class EliteSmashEntity
extends AoABoss {
    protected static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.defineId(EliteSmashEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final AttributeModifier ENRAGED_DAMAGE_MOD = new AttributeModifier(AdventOfAscension.id("enraged"), (double)0.95f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final AttributeModifier ENRAGED_ARMOUR_MOD = new AttributeModifier(AdventOfAscension.id("enraged"), (double)0.9f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final AttributeModifier ENRAGED_TOUGHNESS_MOD = new AttributeModifier(AdventOfAscension.id("enraged"), (double)1.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final int AXE_SWING_STATE = 0;
    private static final int AXE_SLAM_STATE = 1;
    private static final int CHARGE_STATE = 2;
    private static final RawAnimation WALK_BOTTOM_HALF = RawAnimation.begin().thenPlay("move.walk.bottom_half");
    private static final RawAnimation WALK_TOP_HALF = RawAnimation.begin().thenPlay("move.walk.top_half");
    private static final RawAnimation RUN_BOTTOM_HALF = RawAnimation.begin().thenPlay("move.run.bottom_half");
    private static final RawAnimation RUN_TOP_HALF = RawAnimation.begin().thenPlay("move.run.top_half");
    private static final RawAnimation ENRAGE = RawAnimation.begin().thenPlay("misc.enrage");
    private static final RawAnimation ENRAGED_IDLE = RawAnimation.begin().thenPlay("misc.idle.enraged");
    private static final RawAnimation CHARGE_UP = RawAnimation.begin().thenPlay("misc.charge_up");
    private static final RawAnimation CHARGE = RawAnimation.begin().thenPlay("move.charge");
    private static final RawAnimation BELLY_DRUM = RawAnimation.begin().thenPlay("misc.belly_drum");

    public EliteSmashEntity(EntityType<? extends AoABoss> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void addSwingData(AoABoss.SwingData swings) {
        swings.put(0, new AoABoss.SwingData.Swing(20, 13, RawAnimation.begin().thenPlay("attack.axe_swing")));
        swings.put(1, new AoABoss.SwingData.Swing(20, 17, RawAnimation.begin().thenPlay("attack.axe_slam")));
        swings.put(2, new AoABoss.SwingData.Swing(0, 0, RawAnimation.begin().thenPlay("attack.axe_slam")));
    }

    @Override
    @Nullable
    public SoundEvent getMusic() {
        return (SoundEvent)AoASounds.SMASH_MUSIC.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_SMASH_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_SMASH_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ENRAGED, (Object)false);
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if ((double)EntityUtil.getHealthPercent((LivingEntity)this) < 0.3 && !this.isEnraged()) {
            this.enrage();
        }
    }

    protected void enrage() {
        if (!this.isEnraged()) {
            this.getEntityData().set(ENRAGED, (Object)true);
            AttributeUtil.applyPermanentModifier((LivingEntity)this, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, ENRAGED_DAMAGE_MOD);
            AttributeUtil.applyPermanentModifier((LivingEntity)this, (Holder<Attribute>)Attributes.ARMOR, ENRAGED_ARMOUR_MOD);
            AttributeUtil.applyPermanentModifier((LivingEntity)this, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, ENRAGED_TOUGHNESS_MOD);
            this.triggerAnim("arms_controller", "enrage");
            new SoundBuilder((Holder<SoundEvent>)AoASounds.ENTITY_SMASH_ENRAGE).followEntity((Entity)this).category(SoundSource.HOSTILE).execute();
            BrainUtils.setForgettableMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)100);
            BrainUtils.setForgettableMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)100);
        }
    }

    public boolean isEnraged() {
        return (Boolean)this.getEntityData().get(ENRAGED);
    }

    public boolean canDisableShield() {
        return !ATTACK_STATE.is((Entity)this, 1);
    }

    public double getFluidMotionScale(FluidType type) {
        return Math.min(1.0, super.getFluidMotionScale(type) * 4.0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Enraged", this.isEnraged());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Enraged")) {
            this.getEntityData().set(ENRAGED, (Object)compound.getBoolean("Enraged"));
        }
    }

    @Override
    public List<ExtendedSensor<? extends AoABoss>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    @Override
    public BrainActivityGroup<AoABoss> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget().startCondition(entity -> !ATTACK_STATE.is((Entity)this, 2)), new WalkOrRunToWalkTarget().startCondition(entity -> !ATTACK_STATE.is((Entity)this, 2)), new FloatToSurfaceOfFluid()});
    }

    @Override
    public BrainActivityGroup<AoABoss> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().useMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target)).startCondition(entity -> !ATTACK_STATE.is((Entity)this, 2)), new Idle().runFor(entity -> entity.getRandom().nextInt(15, 45))}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})});
    }

    public BrainActivityGroup<AoABoss> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(1.1f)).startCondition(entity -> !ATTACK_STATE.is((Entity)this, 2)), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new OneRandomBehaviour(new Pair[]{Pair.of((Object)new GroundSlamAttack(this.getSwingWarmupTicks(1)).radius(4).slamAtTarget().requiresTarget().whenActivating(entity -> this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)AoASounds.HEAVY_WOODEN_IMPACT.get(), this.getSoundSource(), 1.0f, 1.0f)).cooldownFor(entity -> 5 + (int)((float)this.getSwingDurationTicks(1) * entity.getRandom().nextFloat() * 1.5f)).startCondition(mob -> ATTACK_STATE.is((Entity)this, 1)).whenStopping(entity -> ATTACK_STATE.set((Entity)this, 0)), (Object)20), Pair.of((Object)new FleeTarget().fleeDistance(40).startCondition(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.TARGET_UNREACHABLE.get())) && this.isEnraged()), (Object)1)}), new ReactToUnreachableTarget().timeBeforeReacting(entity -> 40).reaction((entity, isTowering) -> {
            this.enrage();
            ATTACK_STATE.set((Entity)this, 1);
        }), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new GroundSlamAttack(this.getSwingWarmupTicks(1)).radius(4).slamAtTarget().requiresTarget().whenActivating(entity -> this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)AoASounds.HEAVY_WOODEN_IMPACT.get(), this.getSoundSource(), 1.0f, 0.5f)).whenStarting(entity -> ATTACK_STATE.set((Entity)this, 1)).startCondition(entity -> {
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            return target != null && target.distanceToSqr((Entity)entity) < 25.0;
        }).whenStopping(entity -> {
            ATTACK_STATE.set((Entity)this, 0);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)(5 + (int)((float)this.getSwingDurationTicks(1) * entity.getRandom().nextFloat() * 5.0f)));
        }), (Object)1), Pair.of((Object)new AnimatableMeleeAttack(this.getSwingWarmupTicks(0)).attackInterval(entity -> this.getSwingDurationTicks(0) + entity.getRandom().nextInt(5, 15)).startCondition(mob -> ATTACK_STATE.is((Entity)this, 0)), (Object)5)}).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN)), new OneRandomBehaviour(new ExtendedBehaviour[]{new CustomBehaviour(entity -> {
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)90);
            this.triggerAnim("arms_controller", "belly_drum");
            new SoundBuilder((Holder<SoundEvent>)AoASounds.ENTITY_SMASH_BELLY_DRUM).isMonster().followEntity((Entity)this).execute();
            EntityUtil.applyPotions((Entity)entity, new EffectBuilder(MobEffects.DAMAGE_RESISTANCE, 100).level(2), new EffectBuilder(MobEffects.MOVEMENT_SPEED, 100), new EffectBuilder(MobEffects.DAMAGE_BOOST, 100).level(5));
        }).startCondition(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET) && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()))).cooldownFor(entity -> 150).whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)150)), new ChargeAttack(38).speedModifier(1.6f).targetWhenCharging().whenStarting(entity -> {
            this.triggerAnim("arms_controller", "charge_up");
            ATTACK_STATE.set((Entity)this, 2);
        }).whenStopping(entity -> {
            ATTACK_STATE.set((Entity)this, 0);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)150);
        }).cooldownFor(entity -> 150)})})});
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<EliteSmashEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(600.0).moveSpeed(0.315).meleeStrength(30.0).knockbackResist(1.0).followRange(100.0).aggroRange(64.0).armour(15.0, 25.0).knockback(1.0).stepHeight(1.25);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "legs_controller", 0, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.isSprinting() ? RUN_BOTTOM_HALF : WALK_BOTTOM_HALF);
            }
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "arms_controller", 3, state -> {
            if (ATTACK_STATE.is((Entity)this, 2)) {
                return state.setAndContinue(CHARGE);
            }
            if (this.swinging) {
                return state.setAndContinue(this.getSwingAnimation());
            }
            if (state.isMoving()) {
                return state.setAndContinue(this.isSprinting() ? RUN_TOP_HALF : WALK_TOP_HALF);
            }
            return state.setAndContinue(this.isEnraged() ? ENRAGED_IDLE : DefaultAnimations.IDLE);
        }).triggerableAnim("enrage", ENRAGE).triggerableAnim("belly_drum", BELLY_DRUM).triggerableAnim("charge_up", CHARGE_UP));
    }
}

