/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss.king_bambambam;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.AoASoundBuilderPacket;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.content.entity.monster.nether.EmbrakeEntity;
import net.tslat.aoa3.content.entity.monster.nether.LittleBamEntity;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.StickyFireballEntity;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.library.object.TriFunction;
import net.tslat.aoa3.library.object.explosion.StandardExplosion;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EnchantmentUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.HeldBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomDelayedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.NearbyItemsSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class KingBamBamBamEntity
extends AoABoss
implements AoARangedAttacker {
    public static final EntityDataHolder<Boolean> EXHAUSTED = EntityDataHolder.register(KingBamBamBamEntity.class, EntityDataSerializers.BOOLEAN, false, entity -> entity.exhausted, (entity, value) -> {
        entity.exhausted = value;
    });
    public static final EntityDataHolder<Boolean> STAFF_CHARGED = EntityDataHolder.register(KingBamBamBamEntity.class, EntityDataSerializers.BOOLEAN, false, entity -> entity.staffCharged, (entity, value) -> {
        entity.staffCharged = value;
    });
    public static final EntityDataHolder<Integer> ENERGY_LEVEL = EntityDataHolder.register(KingBamBamBamEntity.class, EntityDataSerializers.INT, 100, entity -> entity.energy, (entity, value) -> {
        entity.energy = value;
    });
    private static final RawAnimation EXHAUSTED_ANIM = RawAnimation.begin().thenPlayAndHold("misc.exhaust");
    private static final RawAnimation FIREBALLS_ANIM = RawAnimation.begin().thenPlay("attack.fireballs_start").then("attack.fireballs_loop", new Animation.LoopType(){

        public boolean shouldPlayAgain(GeoAnimatable geoAnimatable, AnimationController<? extends GeoAnimatable> animationController, Animation animation) {
            return AoAMonster.ATTACK_STATE.is((Entity)geoAnimatable, 3);
        }
    }).thenPlay("attack.fireballs_end");
    private static final RawAnimation GET_UP_ANIM = RawAnimation.begin().thenPlay("misc.get_up");
    private static final RawAnimation GOLD_CONSUME_ANIM = RawAnimation.begin().thenPlay("misc.gold_consume");
    private static final RawAnimation STAFF_CHARGE_ANIM = RawAnimation.begin().thenPlay("misc.explosive_charge").thenPlay("misc.explosive_charge_end");
    private static final RawAnimation STAFF_ACTIVE_ANIM = RawAnimation.begin().thenLoop("misc.sphere_spin");
    private static final RawAnimation STAFF_INACTIVE_ANIM = RawAnimation.begin().thenLoop("misc.hide_sphere");
    private static final RawAnimation SUMMON_1_ANIM = RawAnimation.begin().thenLoop("misc.summon");
    private static final RawAnimation SUMMON_2_ANIM = RawAnimation.begin().thenLoop("misc.summon2");
    private static final RawAnimation SUMMON_3_ANIM = RawAnimation.begin().thenLoop("misc.big_summon");
    private static final int SUMMON_1_STATE = 0;
    private static final int SUMMON_2_STATE = 1;
    private static final int SUMMON_3_STATE = 2;
    private static final int FIREBALLS_STATE = 3;
    private boolean exhausted = false;
    private boolean staffCharged = false;
    private int energy = 100;
    public Vector3d orbPos = null;

    public KingBamBamBamEntity(EntityType<? extends KingBamBamBamEntity> entityType, Level level) {
        super((EntityType<? extends AoABoss>)entityType, level);
    }

    @Override
    protected void addSwingData(AoABoss.SwingData swings) {
        swings.put(0, new AoABoss.SwingData.Swing(20, 10, SUMMON_1_ANIM));
        swings.put(1, new AoABoss.SwingData.Swing(20, 12, SUMMON_2_ANIM));
        swings.put(2, new AoABoss.SwingData.Swing(70, 53, SUMMON_3_ANIM));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, EXHAUSTED);
        this.registerDataParams(builder, STAFF_CHARGED);
        this.registerDataParams(builder, ENERGY_LEVEL);
    }

    public float getVoicePitch() {
        return 0.75f;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.PIGLIN_BRUTE_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.PIGLIN_BRUTE_HURT;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.PIGLIN_BRUTE_AMBIENT;
    }

    @Override
    @Nullable
    public SoundEvent getMusic() {
        return (SoundEvent)AoASounds.KING_BAMBAMBAM_MUSIC.get();
    }

    @Override
    public List<ExtendedSensor<? extends AoABoss>> getSensors() {
        Object[] objectArray = new ExtendedSensor[3];
        objectArray[0] = new AggroBasedNearbyPlayersSensor<AoABoss>().onlyAttacking((arg_0, arg_1) -> ((TargetingConditions)TargetingConditions.forCombat().ignoreLineOfSight()).test(arg_0, arg_1)).onlyTargeting((arg_0, arg_1) -> ((TargetingConditions)TargetingConditions.forNonCombat().ignoreLineOfSight()).test(arg_0, arg_1));
        objectArray[1] = new HurtBySensor().setPredicate((source, mob) -> !EntityUtil.isHostileMob((Entity)mob));
        objectArray[2] = new NearbyItemsSensor();
        return ObjectArrayList.of((Object[])objectArray);
    }

    @Override
    public BrainActivityGroup<AoABoss> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget(), new FloatToSurfaceOfFluid()});
    }

    @Override
    public BrainActivityGroup<AoABoss> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target))});
    }

    public BrainActivityGroup<AoABoss> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new LookAtAttackTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new Rest(), new Fireballs(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new SummonMinions(SummonMinions.Variant.LITTLE_BAM, x$0 -> this.getSwingWarmupTicks(x$0)).cooldownFor(entity -> entity.rand().randomNumberBetween(25, 35)), (Object)15), Pair.of((Object)new SummonMinions(SummonMinions.Variant.PIGLIN_BRUTE, x$0 -> this.getSwingWarmupTicks(x$0)).cooldownFor(entity -> entity.rand().randomNumberBetween(40, 60)), (Object)10), Pair.of((Object)new SummonMinions(SummonMinions.Variant.EMBRAKE, x$0 -> this.getSwingWarmupTicks(x$0)).cooldownFor(entity -> entity.rand().randomNumberBetween(75, 90)), (Object)5), Pair.of((Object)new CustomDelayedBehaviour(60).whenActivating(entity -> {
            STAFF_CHARGED.set((Entity)entity, true);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)5);
            if (!EntityRetrievalUtil.getPlayers((Level)entity.level(), (AABB)this.getBoundingBox().expandTowards(this.getForward().multiply(3.0, 1.25, 3.0))).isEmpty()) {
                new StandardExplosion(AoAExplosions.KING_BAMBAMBAM_DISCHARGE, (ServerLevel)entity.level(), (Entity)entity, entity.position().add(0.0, 0.5, 0.0).add(entity.getForward().multiply(1.5, 1.5, 1.5))).explode();
            }
        }).whenStarting(entity -> this.triggerAnim("Sphere", "Charge")).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN)).cooldownFor(entity -> this.rand().randomNumberBetween(2000, 3000)), (Object)50)}).startCondition(entity -> STAFF_CHARGED.is((Entity)entity, false))})});
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.orbPos != null) {
            ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.FLAME, (double)(this.orbPos.x + this.getRandom().nextGaussian() * (double)0.1f), (double)(this.orbPos.y + this.getRandom().nextGaussian() * (double)0.1f), (double)(this.orbPos.z + this.getRandom().nextGaussian() * (double)0.1f)).ignoreDistanceAndLimits().velocity(0.0, 0.05, 0.0).spawnParticles(this.level());
        }
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.tickCount % 5 == 0) {
            this.addEnergy(1);
        }
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        if (EXHAUSTED.is((Entity)this, false)) {
            this.consumeEnergy((int)Math.floor(damageContainer.getNewDamage()));
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.is(DamageTypeTags.IS_EXPLOSION) && source.getEntity() instanceof LittleBamEntity) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public void addEnergy(int amount) {
        ENERGY_LEVEL.set((Entity)this, Math.min(ENERGY_LEVEL.get((Entity)this) + amount, 100));
    }

    public void consumeEnergy(int amount) {
        ENERGY_LEVEL.set((Entity)this, Math.max(ENERGY_LEVEL.get((Entity)this) - amount, 0));
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<KingBamBamBamEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(740.0).moveSpeed(0.2875f).projectileDamage(12.0).knockbackResist(1.0).followRange(100.0).aggroRange(64.0).armour(10.0, 30.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this).setAnimationSpeed((double)1.2f));
        controllers.add(new AnimationController((GeoAnimatable)this, "Summoning", 0, state -> {
            if (this.swinging) {
                return state.setAndContinue(this.getSwingAnimation());
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "Sphere", 0, state -> {
            if (STAFF_CHARGED.is((Entity)this, false)) {
                return state.setAndContinue(STAFF_INACTIVE_ANIM);
            }
            return state.setAndContinue(STAFF_ACTIVE_ANIM);
        }).triggerableAnim("Charge", STAFF_CHARGE_ANIM));
        controllers.add(new AnimationController((GeoAnimatable)this, "Fireballs", 0, state -> {
            if (ATTACK_STATE.is((Entity)this, 3) || !state.getController().hasAnimationFinished() && state.getController().getCurrentAnimation() != null && state.getController().getCurrentAnimation().animation().name().equals("attack.fireballs_end")) {
                return state.setAndContinue(FIREBALLS_ANIM);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "Exhaustion", 5, state -> {
            if (EXHAUSTED.is((Entity)this, true)) {
                return state.setAndContinue(EXHAUSTED_ANIM);
            }
            if (state.isCurrentAnimation(EXHAUSTED_ANIM) || state.isCurrentAnimation(GET_UP_ANIM) && !state.getController().hasAnimationFinished()) {
                return state.setAndContinue(GET_UP_ANIM);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "Gold Consumption", 0, state -> PlayState.STOP).triggerableAnim("consume", GOLD_CONSUME_ANIM));
    }

    public void performRangedAttack(LivingEntity pTarget, float pVelocity) {
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        if (DamageUtil.doProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE))) {
            target.igniteForSeconds((float)((int)Math.ceil((float)Math.max(0, target.getRemainingFireTicks()) / 20.0f) + 2));
        }
    }

    @Override
    public void doRangedAttackBlock(@Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    public void remove(Entity.RemovalReason pReason) {
        super.remove(pReason);
    }

    public static class Rest
    extends HeldBehaviour<AoABoss> {
        public Rest() {
            this.runFor(entity -> 200);
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return List.of();
        }

        protected boolean checkExtraStartConditions(ServerLevel level, AoABoss entity) {
            return ENERGY_LEVEL.is((Entity)entity, 0);
        }

        protected boolean shouldKeepRunning(AoABoss entity) {
            return !ENERGY_LEVEL.is((Entity)entity, 100);
        }

        protected void start(AoABoss entity) {
            EXHAUSTED.set((Entity)entity, true);
            entity.setDeltaMovement(0.0, 0.0, 0.0);
            entity.getNavigation().stop();
            BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.PATH);
            AoANetworking.sendToAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder((Holder<SoundEvent>)AoASounds.ENTITY_KING_BAMBAMBAM_EXHAUSTED).followEntity((Entity)entity)), (Entity)entity);
        }

        protected void stop(AoABoss entity) {
            EXHAUSTED.set((Entity)entity, false);
            ((KingBamBamBamEntity)entity).addEnergy(100);
        }
    }

    public static class Fireballs
    extends HeldBehaviour<AoABoss> {
        private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT)});

        public Fireballs() {
            this.runFor(entity -> 200);
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, AoABoss entity) {
            return STAFF_CHARGED.is((Entity)entity, true);
        }

        protected boolean shouldKeepRunning(AoABoss entity) {
            return !ENERGY_LEVEL.is((Entity)entity, 0);
        }

        protected void start(AoABoss entity) {
            AoAMonster.ATTACK_STATE.set((Entity)entity, 3);
        }

        protected void stop(AoABoss entity) {
            AoAMonster.ATTACK_STATE.set((Entity)entity, 0);
            STAFF_CHARGED.set((Entity)entity, false);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)60);
        }

        protected void tick(AoABoss entity) {
            if (this.runningTime < 20) {
                return;
            }
            Vec3 forward = entity.getForward();
            Vec3 left = Vec3.directionFromRotation((float)entity.getXRot(), (float)(entity.getYRot() + 90.0f));
            for (int i = 0; i < 2; ++i) {
                StickyFireballEntity fireball = new StickyFireballEntity(entity.level(), (KingBamBamBamEntity)entity, BaseMobProjectile.Type.PHYSICAL);
                fireball.setPos((forward.x + left.x) * 0.25 + entity.getRandomX(0.25), entity.getY() + 4.5, (forward.z + left.z) * 0.25 + entity.getRandomZ(0.25));
                fireball.setDeltaMovement(entity.getRandom().nextGaussian() * (double)0.15f, 1.2f, entity.getRandom().nextGaussian() * (double)0.15f);
                entity.level().addFreshEntity((Entity)fireball);
            }
            if (this.getRunningTime() % 9 == 0 || this.getRunningTime() % 20 == 0) {
                entity.playSound((SoundEvent)AoASounds.FLAMETHROWER.get(), 2.0f, 0.5f);
            }
        }
    }

    public static class SummonMinions
    extends DelayedBehaviour<AoABoss> {
        private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT)});
        private static final Item[] LOOT_ITEMS = new Item[]{Items.GOLDEN_PICKAXE, Items.GOLDEN_HOE, Items.GOLDEN_SHOVEL, Items.GOLDEN_SWORD, Items.GOLDEN_AXE, Items.GOLDEN_HORSE_ARMOR, Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS, Items.GOLD_INGOT, Items.GOLD_NUGGET};
        private final Variant variant;

        public SummonMinions(Variant variant, Int2IntFunction delayFunction) {
            super(((Integer)delayFunction.apply((Object)variant.ordinal())).intValue());
            this.variant = variant;
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
        }

        protected void start(AoABoss entity) {
            AoAMonster.ATTACK_STATE.set((Entity)entity, this.variant.ordinal());
            entity.swing(InteractionHand.MAIN_HAND);
            AoANetworking.sendToAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder(this.variant.summonSound).followEntity((Entity)entity).category(SoundSource.HOSTILE)), (Entity)entity);
        }

        protected void doDelayedAction(AoABoss entity) {
            Vec3 spawnPos = Vec3.atBottomCenterOf((Vec3i)RandomUtil.getRandomPositionWithinRange((BlockPos)entity.blockPosition(), (int)4, (int)2, (int)4, (int)1, (int)0, (int)1, (boolean)false, (Level)entity.level(), (int)5, (state, pos) -> Math.abs((double)pos.getY() - entity.getY()) <= 5.0));
            PositionAndMotionUtil.getNearestOnGroundPosition(entity.level(), spawnPos).ifPresent(pos -> {
                LivingEntity minion = this.variant.spawnFunction.apply(entity, (Vec3)pos, (LivingEntity)BrainUtils.memoryOrDefault((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY, () -> null));
                if (minion != null) {
                    LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
                    ((KingBamBamBamEntity)entity).consumeEnergy(this.variant.energyCost);
                    if (target != null) {
                        BrainUtils.setMemory((LivingEntity)minion, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET, (Object)target);
                    }
                    ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.SMALL_FLAME, (Entity)minion).spawnNTimes(50).lifespan(40).ignoreDistanceAndLimits().sendToAllPlayersTrackingEntity((ServerLevel)entity.level(), (Entity)entity);
                    AoANetworking.sendToAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder(SoundEvents.BLAZE_SHOOT).followEntity((Entity)entity).category(SoundSource.HOSTILE).pitch(0.5f).varyPitch(0.1f)), (Entity)entity);
                }
            });
        }

        protected void stop(AoABoss entity) {
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)entity.rand().randomNumberBetween((this.variant.ordinal() + 1) * 40, (this.variant.ordinal() + 1) * 60));
        }

        @Nullable
        private static LivingEntity summonLittleBam(final AoABoss entity, Vec3 pos, @Nullable LivingEntity target) {
            LittleBamEntity littleBam = new LittleBamEntity((EntityType)AoAMonsters.LITTLE_BAM.get(), entity.level()){
                private final AoABoss kingBamBamBam;
                {
                    super((EntityType<? extends LittleBamEntity>)arg0, arg1);
                    this.kingBamBamBam = entity;
                }

                public boolean isInvulnerableTo(DamageSource source) {
                    return source.is(DamageTypeTags.IS_EXPLOSION) || super.isInvulnerableTo(source) || source.getEntity() != null && PlayerUtil.getPlayerOrOwnerIfApplicable(source.getEntity()) == null;
                }

                @Override
                public void tick() {
                    super.tick();
                    if (this.kingBamBamBam == null || !this.kingBamBamBam.isAlive() || this.tickCount > 12000) {
                        this.discard();
                    }
                }

                public boolean shouldBeSaved() {
                    return false;
                }

                protected void dropAllDeathLoot(ServerLevel level, DamageSource source) {
                    for (int i = 0; i < 3; ++i) {
                        SummonMinions.createMagnetisedItemStack(entity, this.getEyePosition().add(0.0, (double)0.1f, 0.0), new Vec3(entity.rand().randomScaledGaussianValue(0.5), 0.5, entity.rand().randomScaledGaussianValue(0.5)), (Item)entity.rand().getRandomSelection((Object[])LOOT_ITEMS));
                    }
                }

                public void setTarget(@Nullable LivingEntity target) {
                    if (target != null && target.getType() != EntityType.PLAYER) {
                        return;
                    }
                    super.setTarget(target);
                }
            };
            littleBam.setTarget(target);
            littleBam.setPos(pos);
            EventHooks.finalizeMobSpawn((Mob)littleBam, (ServerLevelAccessor)((ServerLevel)littleBam.level()), (DifficultyInstance)littleBam.level().getCurrentDifficultyAt(littleBam.blockPosition()), (MobSpawnType)MobSpawnType.REINFORCEMENT, null);
            return entity.level().addFreshEntity((Entity)littleBam) ? littleBam : null;
        }

        @Nullable
        private static LivingEntity summonPiglinBrute(final AoABoss entity, Vec3 pos, @Nullable LivingEntity target) {
            PiglinBrute piglin = new PiglinBrute(EntityType.PIGLIN_BRUTE, entity.level()){
                private final AoABoss kingBamBamBam;
                {
                    super(arg0, arg1);
                    this.kingBamBamBam = entity;
                }

                public boolean isInvulnerableTo(DamageSource source) {
                    return source.is(DamageTypeTags.IS_EXPLOSION) || super.isInvulnerableTo(source) || source.getEntity() != null && PlayerUtil.getPlayerOrOwnerIfApplicable(source.getEntity()) == null;
                }

                public void tick() {
                    super.tick();
                    if (this.kingBamBamBam == null || !this.kingBamBamBam.isAlive() || this.tickCount > 12000) {
                        this.discard();
                    }
                }

                public boolean shouldBeSaved() {
                    return false;
                }

                protected void dropAllDeathLoot(ServerLevel level, DamageSource source) {
                    for (int i = 0; i < 3; ++i) {
                        SummonMinions.createMagnetisedItemStack(entity, this.getEyePosition().add(0.0, (double)0.1f, 0.0), new Vec3(entity.rand().randomScaledGaussianValue(0.5), 0.25, entity.rand().randomScaledGaussianValue(0.5)), (Item)entity.rand().getRandomSelection((Object[])LOOT_ITEMS));
                    }
                }

                public void setTarget(@Nullable LivingEntity target) {
                    if (target != null && target.getType() != EntityType.PLAYER) {
                        return;
                    }
                    super.setTarget(target);
                }
            };
            piglin.setTarget(target);
            piglin.setPos(pos);
            EventHooks.finalizeMobSpawn((Mob)piglin, (ServerLevelAccessor)((ServerLevel)piglin.level()), (DifficultyInstance)piglin.level().getCurrentDifficultyAt(piglin.blockPosition()), (MobSpawnType)MobSpawnType.REINFORCEMENT, null);
            return entity.level().addFreshEntity((Entity)piglin) ? piglin : null;
        }

        @Nullable
        private static LivingEntity summonEmbrake(final AoABoss entity, Vec3 pos, @Nullable LivingEntity target) {
            EmbrakeEntity embrake = new EmbrakeEntity((EntityType)AoAMonsters.EMBRAKE.get(), entity.level()){
                private final AoABoss kingBamBamBam;
                {
                    super((EntityType<? extends EmbrakeEntity>)arg0, arg1);
                    this.kingBamBamBam = entity;
                }

                public boolean isInvulnerableTo(DamageSource source) {
                    return source.is(DamageTypeTags.IS_EXPLOSION) || super.isInvulnerableTo(source) || source.getEntity() != null && PlayerUtil.getPlayerOrOwnerIfApplicable(source.getEntity()) == null;
                }

                @Override
                public void tick() {
                    super.tick();
                    if (this.kingBamBamBam == null || !this.kingBamBamBam.isAlive() || this.tickCount > 12000) {
                        this.discard();
                    }
                }

                public boolean shouldBeSaved() {
                    return false;
                }

                protected void dropAllDeathLoot(ServerLevel level, DamageSource source) {
                    for (int i = 0; i < 3; ++i) {
                        SummonMinions.createMagnetisedItemStack(entity, this.getEyePosition().add(0.0, (double)0.1f, 0.0), new Vec3(entity.rand().randomScaledGaussianValue((double)0.3f), 0.25, entity.rand().randomScaledGaussianValue((double)0.3f)), (Item)entity.rand().getRandomSelection((Object[])LOOT_ITEMS));
                    }
                }

                public void setTarget(@Nullable LivingEntity target) {
                    if (target != null && target.getType() != EntityType.PLAYER) {
                        return;
                    }
                    super.setTarget(target);
                }
            };
            embrake.setTarget(target);
            embrake.setPos(pos);
            EventHooks.finalizeMobSpawn((Mob)embrake, (ServerLevelAccessor)((ServerLevel)embrake.level()), (DifficultyInstance)embrake.level().getCurrentDifficultyAt(embrake.blockPosition()), (MobSpawnType)MobSpawnType.REINFORCEMENT, null);
            return entity.level().addFreshEntity((Entity)embrake) ? embrake : null;
        }

        private static void createMagnetisedItemStack(final AoABoss boss, Vec3 pos, Vec3 velocity, Item item) {
            ItemStack stack = item.getDefaultInstance();
            EnchantmentUtil.addEnchantment(boss.level(), stack, (ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE);
            ItemEntity itemEntity = new ItemEntity(boss.level(), pos.x, pos.y, pos.z, stack, velocity.x, velocity.y, velocity.z){
                private final AoABoss magnetisedTo;
                {
                    super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
                    this.magnetisedTo = boss;
                }

                public void tick() {
                    if (this.magnetisedTo == null || !this.magnetisedTo.isAlive()) {
                        this.discard();
                    } else if (this.getY() < (double)this.level().getMinBuildHeight()) {
                        this.discard();
                    } else if (this.tickCount > 60) {
                        this.hurtMarked = true;
                        this.noPhysics = true;
                        Vec3 startPos = this.getEyePosition().add(0.0, (double)0.15f, 0.0);
                        Vec3 travelVector = this.magnetisedTo.getEyePosition().subtract(0.0, (double)0.2f, 0.0).subtract(startPos);
                        Vec3 angle = travelVector.normalize();
                        double dist = travelVector.length();
                        TELParticlePacket particlePacket = new TELParticlePacket();
                        this.setNoGravity(true);
                        this.setDeltaMovement(angle.scale((double)0.08f));
                        float i = 0.25f;
                        while ((double)i < dist) {
                            particlePacket.particle(ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (Vec3[])new Vec3[]{startPos.add(angle.multiply((double)i, (double)i, (double)i))}).colourOverride(1.0f, 1.0f, 1.0f, 0.15f));
                            i += 0.5f;
                        }
                        if (this.magnetisedTo.distanceToSqr((Entity)this) < (double)3.1f) {
                            this.magnetisedTo.heal(50.0f);
                            ((KingBamBamBamEntity)this.magnetisedTo).addEnergy(30);
                            this.magnetisedTo.triggerAnim("Gold Consumption", "consume");
                            AoANetworking.sendToAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD).followEntity((Entity)this.magnetisedTo).category(SoundSource.HOSTILE).pitch(0.3f).varyPitch(0.1f)), (Entity)this.magnetisedTo);
                            particlePacket.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.HEART, (Entity)this.magnetisedTo).spawnNTimes(10));
                            this.discard();
                        } else if (!EntityRetrievalUtil.getPlayers((Level)this.level(), (AABB)this.getBoundingBox().inflate(0.75, 2.0, 0.75)).isEmpty()) {
                            AoANetworking.sendToAllNearbyPlayers(new AoASoundBuilderPacket(new SoundBuilder((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD).category(SoundSource.PLAYERS).atPos(this.level(), this.position().x, this.position().y, this.position().z)), (ServerLevel)this.level(), this.position(), 6.0);
                            this.discard();
                        }
                        particlePacket.sendToAllPlayersTrackingEntity((ServerLevel)this.level(), (Entity)this.magnetisedTo);
                    }
                    super.tick();
                }

                public boolean shouldBeSaved() {
                    return false;
                }

                public boolean hurt(DamageSource pSource, float pAmount) {
                    this.discard();
                    return true;
                }

                public boolean hasPickUpDelay() {
                    if (this.tickCount > 5) {
                        this.setItem(ItemStack.EMPTY);
                    }
                    return true;
                }
            };
            itemEntity.setNeverPickUp();
            boss.level().addFreshEntity((Entity)itemEntity);
        }

        public static enum Variant {
            LITTLE_BAM((Holder<SoundEvent>)AoASounds.ENTITY_KING_BAMBAMBAM_SUMMON_1, 20, SummonMinions::summonLittleBam),
            PIGLIN_BRUTE((Holder<SoundEvent>)AoASounds.ENTITY_KING_BAMBAMBAM_SUMMON_2, 30, SummonMinions::summonPiglinBrute),
            EMBRAKE((Holder<SoundEvent>)AoASounds.ENTITY_KING_BAMBAMBAM_SUMMON_3, 40, SummonMinions::summonEmbrake);

            private final Holder<SoundEvent> summonSound;
            private final int energyCost;
            private final TriFunction<AoABoss, Vec3, LivingEntity, LivingEntity> spawnFunction;

            private Variant(Holder<SoundEvent> summonSound, int energyCost, TriFunction<AoABoss, Vec3, LivingEntity, LivingEntity> spawnFunction) {
                this.summonSound = summonSound;
                this.energyCost = energyCost;
                this.spawnFunction = spawnFunction;
            }
        }
    }
}

