/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.world.nowhere.NowhereBossArena;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.RawAnimation;

public abstract class AoABoss
extends AoAMonster<AoABoss> {
    private final ServerBossEvent bossStatusTracker = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.NOTCHED_20).setDarkenScreen(false).setCreateWorldFog(false);
    private SwingData swingData;
    private int lastArenaBoundTick = -1;

    protected AoABoss(EntityType<? extends AoABoss> entityType, Level level) {
        super(entityType, level);
        this.bossStatusTracker.id = this.getUUID();
        this.noCulling = true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.swingData = new SwingData();
        this.addSwingData(this.swingData);
    }

    protected void addSwingData(SwingData swings) {
    }

    @Override
    public int calculateKillXp() {
        return !this.hasDrops ? 0 : 2 * (int)(5.0 + (this.getAttributeValue(Attributes.MAX_HEALTH) + this.getAttributeValue(Attributes.ARMOR) * 1.75 + this.getAttributeValue(Attributes.ATTACK_DAMAGE) * 2.0) / 10.0);
    }

    @Nullable
    public abstract SoundEvent getMusic();

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    protected boolean canRide(Entity entity) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (this.hasCustomName()) {
            this.bossStatusTracker.setName(this.getDisplayName());
        }
        this.bossStatusTracker.id = this.getUUID();
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossStatusTracker.setName(this.getDisplayName());
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        this.bossStatusTracker.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.level().dimension() == AoADimensions.NOWHERE && this.tickCount % 60 == 0) {
            if (this.level().getHeight(Heightmap.Types.MOTION_BLOCKING, (int)this.getX(), (int)this.getZ()) == this.level().getMinBuildHeight()) {
                if (this.lastArenaBoundTick != -1 && this.tickCount - this.lastArenaBoundTick >= 180) {
                    this.lastArenaBoundTick = -1;
                    NowhereBossArena arena = NowhereBossArena.getClosestArena((ServerLevel)this.level(), this.position());
                    if (arena != null) {
                        this.resetFallDistance();
                        this.setPos(arena.getRandomBossSpawn());
                    } else {
                        this.discard();
                    }
                } else if (this.lastArenaBoundTick == -1) {
                    this.lastArenaBoundTick = this.tickCount;
                }
            } else if (this.lastArenaBoundTick != -1) {
                this.lastArenaBoundTick = -1;
            }
        }
    }

    public SwingData getSwingData() {
        return this.swingData;
    }

    protected RawAnimation getSwingAnimation() {
        return this.getSwingAnimation((Integer)ATTACK_STATE.get((Entity)this));
    }

    protected RawAnimation getSwingAnimation(int state) {
        return this.swingData.getSwingAnimation(state);
    }

    protected int getSwingDurationTicks() {
        return this.getSwingDurationTicks((Integer)ATTACK_STATE.get((Entity)this));
    }

    protected int getSwingDurationTicks(int state) {
        return this.swingData.getSwingLength(state);
    }

    protected int getSwingWarmupTicks() {
        return this.getSwingWarmupTicks((Integer)ATTACK_STATE.get((Entity)this));
    }

    protected int getSwingWarmupTicks(int state) {
        return this.swingData.getSwingPreHurtTime(state);
    }

    @Override
    public int getCurrentSwingDuration() {
        int time = this.getSwingDurationTicks();
        if (MobEffectUtil.hasDigSpeed((LivingEntity)this)) {
            time -= 1 + MobEffectUtil.getDigSpeedAmplification((LivingEntity)this);
        }
        if (this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            time += (1 + this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) * 2;
        }
        return time;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossStatusTracker.addPlayer(player);
        if (this.getMusic() != null && this.level().dimension() != AoADimensions.NOWHERE) {
            new SoundBuilder(this.getMusic()).isMusic().include(new Player[]{player}).execute();
        }
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossStatusTracker.removePlayer(player);
        if (this.getMusic() != null) {
            new SoundBuilder(this.getMusic()).isMusic().stopSound().include(new Player[]{player}).execute();
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        NowhereBossArena arena;
        if (source.is(DamageTypes.FELL_OUT_OF_WORLD) && WorldUtil.isWorld(this.level(), AoADimensions.NOWHERE) && !this.level().isClientSide() && this.getY() < (double)this.level().getMinBuildHeight() && (arena = NowhereBossArena.getClosestArena((ServerLevel)this.level(), this.position())) != null) {
            this.resetFallDistance();
            this.setPos(arena.getRandomBossSpawn());
            return false;
        }
        return super.hurt(source, amount);
    }

    public record SwingData(Int2ObjectMap<Swing> data) {
        public SwingData() {
            this((Int2ObjectMap<Swing>)((Int2ObjectMap)Util.make((Object)new Int2ObjectOpenHashMap(), map -> map.defaultReturnValue((Object)new Swing(0, 0, RawAnimation.begin())))));
        }

        public void put(int key, Swing swing) {
            this.data.put(key, (Object)swing);
        }

        public Swing getSwing(int key) {
            return (Swing)this.data.get(key);
        }

        public int getSwingLength(int key) {
            return this.getSwing(key).animLength();
        }

        public int getSwingPreHurtTime(int key) {
            return this.getSwing(key).warmupTicks();
        }

        public RawAnimation getSwingAnimation(int key) {
            return this.getSwing(key).anim();
        }

        public record Swing(int animLength, int warmupTicks, RawAnimation anim) {
        }
    }
}

