/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class LavaMobEntity
extends PathfinderMob {
    protected LavaMobEntity(EntityType<? extends LavaMobEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public boolean checkSpawnObstruction(LevelReader pLevel) {
        return pLevel.isUnobstructed((Entity)this);
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    protected int getExperienceReward(Player pPlayer) {
        return 1 + this.level().random.nextInt(3);
    }

    protected void handleAirSupply(int air) {
        if (this.isAlive() && !this.isInLava()) {
            this.setAirSupply(air - 1);
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                this.hurt(this.level().damageSources().drown(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == NeoForgeMod.LAVA_TYPE.value()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypeTags.IS_FIRE) || super.isInvulnerableTo(source);
    }

    public void baseTick() {
        int air = this.getAirSupply();
        super.baseTick();
        this.handleAirSupply(air);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canBeLeashed(Player player) {
        return false;
    }
}

