/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import net.minecraft.world.entity.Entity;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.MultipartTogglePacket;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;

public interface AoAMultipartEntity {
    public void setParts(AoAEntityPart<?> ... var1);

    public AoAEntityPart<?>[] getParts();

    default public void defineParts(AtomicInteger idCounter, IntConsumer idSetter, AoAEntityPart<?> ... parts) {
        idSetter.accept(idCounter.getAndAdd(parts.length + 1) + 1);
    }

    default public void setMultipartIds(int baseId) {
        int newId = baseId + 1;
        for (AoAEntityPart<?> part : this.getParts()) {
            part.setId(newId++);
        }
    }

    default public void updateMultipartPositions() {
        for (AoAEntityPart<?> part : this.getParts()) {
            part.updatePosition();
        }
    }

    default public void refreshMultipartDimensions() {
        if (this.isMultipartActive()) {
            for (AoAEntityPart<?> part : this.getParts()) {
                part.refreshDimensions();
            }
        }
    }

    default public void toggleMultipart(boolean enabled) {
        for (AoAEntityPart<?> part : this.getParts()) {
            part.setEnabled(enabled);
        }
        Entity self = (Entity)this;
        if (!self.level().isClientSide()) {
            AoANetworking.sendToAllPlayersTrackingEntity(new MultipartTogglePacket(self.getId(), enabled), self);
        }
    }

    default public boolean isMultipartActive() {
        for (AoAEntityPart<?> part : this.getParts()) {
            if (!part.isEnabled()) continue;
            return true;
        }
        return false;
    }
}

