/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.tslat.aoa3.content.entity.ai.movehelper.MultiFluidSmoothGroundNavigation;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMultipartEntity;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyLivingEntitySensor;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AoAMonster<T extends AoAMonster<T>>
extends Monster
implements GeoEntity,
SmartBrainOwner<T>,
AoAMultipartEntity {
    public static final EntityDataHolder<Integer> ATTACK_STATE = EntityDataHolder.register(AoAMonster.class, EntityDataSerializers.INT, 0, monster -> monster.attackState, (monster, value) -> {
        monster.attackState = value;
    });
    public static final EntityDataHolder<Boolean> INVULNERABLE = EntityDataHolder.register(AoAMonster.class, EntityDataSerializers.BOOLEAN, false, Entity::isInvulnerable, AoAMonster::setInvulnerable);
    public static final EntityDataHolder<Boolean> IMMOBILE = EntityDataHolder.register(AoAMonster.class, EntityDataSerializers.BOOLEAN, false, monster -> monster.immobile, (monster, value) -> {
        monster.immobile = value;
    });
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected AoAEntityPart<?>[] parts = new AoAEntityPart[0];
    private EntityDataHolder<?>[] dataParams;
    protected boolean hasDrops = true;
    private int attackState = 0;
    private boolean immobile = false;

    protected AoAMonster(EntityType<? extends AoAMonster> entityType, Level level) {
        super(entityType, level);
        this.getNavigation().setCanFloat(true);
    }

    protected PathNavigation createNavigation(Level level) {
        return new MultiFluidSmoothGroundNavigation((Mob)this, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        for (EntityDataHolder<?> dataHolder : this.dataParams = new EntityDataHolder[]{ATTACK_STATE, INVULNERABLE, IMMOBILE}) {
            dataHolder.defineDefault(builder);
        }
    }

    protected final void registerDataParams(SynchedEntityData.Builder builder, EntityDataHolder<?> ... params) {
        EntityDataHolder[] newArray = new EntityDataHolder[this.dataParams.length + params.length];
        System.arraycopy(this.dataParams, 0, newArray, 0, this.dataParams.length);
        System.arraycopy(params, 0, newArray, this.dataParams.length, params.length);
        for (EntityDataHolder<?> param : params) {
            param.defineDefault(builder);
        }
        this.dataParams = newArray;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return null;
    }

    protected float nextStep() {
        return this.moveDist + 1.0f;
    }

    protected float getStepWeight() {
        return 1.0f;
    }

    protected boolean isQuadruped() {
        return false;
    }

    public int getAmbientSoundInterval() {
        return 240;
    }

    public final RandomUtil.EasyRandom rand() {
        return new RandomUtil.EasyRandom(this.getRandom());
    }

    protected Brain.Provider<T> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<? extends T>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new AggroBasedNearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).getOwnerUUID() != null;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    public BrainActivityGroup<? extends T> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget().startCondition(entity -> !this.isDoingStationaryActivity()), new FloatToSurfaceOfFluid()});
    }

    public BrainActivityGroup<? extends T> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target)), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})});
    }

    protected int getAttackSwingDuration() {
        return 6;
    }

    protected int getPreAttackTime() {
        return 0;
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType spawnReason) {
        return true;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.hasDrops = spawnType != MobSpawnType.MOB_SUMMONED;
        this.xpReward = this.calculateKillXp();
        if (spawnType == MobSpawnType.SPAWNER) {
            this.xpReward = (int)((double)this.xpReward * 0.5);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public int calculateKillXp() {
        return !this.hasDrops ? 0 : (int)(5.0 + (this.getAttributeValue(Attributes.MAX_HEALTH) + this.getAttributeValue(Attributes.ARMOR) * 1.75 + this.getAttributeValue(Attributes.ARMOR_TOUGHNESS) * 1.5) / 10.0);
    }

    protected void playStepSound(BlockPos pos, BlockState blockState) {
        if (!blockState.liquid()) {
            BlockState state = this.level().getBlockState(pos.above());
            SoundType blockSound = state.getBlock() == Blocks.SNOW ? state.getSoundType((LevelReader)this.level(), pos, (Entity)this) : blockState.getSoundType((LevelReader)this.level(), pos, (Entity)this);
            SoundEvent stepSound = blockSound.getStepSound();
            SoundEvent stepSoundOverlay = this.getStepSound(pos, blockState);
            this.playStepSounds(stepSound, stepSoundOverlay);
            if (this.isQuadruped() && !this.level().isClientSide) {
                AoAScheduler.scheduleSyncronisedTask(() -> this.playStepSounds(stepSound, stepSoundOverlay), 6);
            }
        }
    }

    private void playStepSounds(SoundEvent stepSound, @Nullable SoundEvent stepSoundOverlay) {
        float stepWeight = this.getStepWeight() - 1.0f;
        this.playSound(stepSound, 0.75f + stepWeight * 0.15f, 1.0f - stepWeight * 0.1f);
        if (stepSoundOverlay != null) {
            this.playSound(stepSoundOverlay, 0.75f + stepWeight * 0.15f, 1.0f - stepWeight * 0.1f);
        }
    }

    public int getCurrentSwingDuration() {
        int time = this.getAttackSwingDuration();
        if (MobEffectUtil.hasDigSpeed((LivingEntity)this)) {
            time -= 1 + MobEffectUtil.getDigSpeedAmplification((LivingEntity)this);
        }
        if (this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            time += (1 + this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) * 2;
        }
        return time;
    }

    protected void customServerAiStep() {
        this.tickBrain((LivingEntity)this);
    }

    @Nullable
    public LivingEntity getTarget() {
        return BrainUtils.getTargetOfEntity((LivingEntity)this, (LivingEntity)super.getTarget());
    }

    public void setImmobile(boolean immobile) {
        IMMOBILE.set((Entity)this, immobile);
        if (this.immobile) {
            this.getNavigation().stop();
        }
    }

    public boolean isDoingStationaryActivity() {
        return this.immobile;
    }

    public boolean hurt(DamageSource source, float amount) {
        AbstractArrow arrow;
        AoAEntityPart<?>[] aoAEntityPartArray;
        if (this.parts.length > 0 && (aoAEntityPartArray = source.getDirectEntity()) instanceof AbstractArrow && (arrow = (AbstractArrow)aoAEntityPartArray).getPierceLevel() > 0) {
            if (arrow.piercingIgnoreEntityIds == null) {
                arrow.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            for (AoAEntityPart<?> part : this.parts) {
                arrow.piercingIgnoreEntityIds.add(part.getId());
            }
            arrow.piercingIgnoreEntityIds.add(this.getId());
        }
        return super.hurt(source, amount);
    }

    public boolean doHurtTarget(Entity target) {
        ServerLevel serverLevel;
        float damage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)damage);
        }
        if (target.hurt(damageSource, damage)) {
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                float knockback = this.getKnockback(target, damageSource);
                if (knockback > 0.0f) {
                    livingTarget.knockback((double)(knockback * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                }
            }
            if ((level = this.level()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)damageSource);
            }
            this.setLastHurtMob(target);
            this.playAttackSound();
            this.onAttack(target);
            return true;
        }
        return false;
    }

    protected DamageSource getAttackDamageSource(Entity target) {
        return this.damageSources().mobAttack((LivingEntity)this);
    }

    protected void onAttack(Entity target) {
    }

    public void die(DamageSource source) {
        if (CommonHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        if (!this.isRemoved() && !this.dead) {
            Entity lastAttacker = source.getEntity();
            LivingEntity killer = this.getKillCredit();
            if (this.deathScore >= 0 && killer != null) {
                killer.awardKillScore((Entity)this, this.deathScore, source);
            }
            if (this.isSleeping()) {
                this.stopSleeping();
            }
            this.dead = true;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (lastAttacker == null || lastAttacker.killedEntity(serverLevel, (LivingEntity)this)) {
                    this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                    this.dropAllDeathLoot(serverLevel, source);
                    this.createWitherRose(killer);
                }
                serverLevel.broadcastEntityEvent((Entity)this, (byte)3);
            }
            this.getCombatTracker().recheckStatus();
            this.setPose(Pose.DYING);
        }
    }

    public void setInvulnerable(boolean isInvulnerable) {
        if (!INVULNERABLE.is((Entity)this, isInvulnerable)) {
            INVULNERABLE.setRaw((Entity)this, isInvulnerable);
        }
        super.setInvulnerable(isInvulnerable);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        for (EntityDataHolder<?> dataHolder : this.dataParams) {
            if (dataHolder.checkSync((Entity)this, key)) break;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DropsLoot", this.hasDrops);
        if (this.getParts().length > 0) {
            ObjectArrayList disabledParts = new ObjectArrayList();
            for (int i = 0; i < this.getParts().length; ++i) {
                if (this.getParts()[i].isEnabled()) continue;
                disabledParts.add(i);
            }
            if (!disabledParts.isEmpty()) {
                compound.put("DisabledMultiparts", (Tag)new IntArrayTag((List)disabledParts));
            }
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.hasDrops = compound.getBoolean("DropsLoot");
        if (compound.contains("DisabledMultiparts", 11)) {
            AoAEntityPart<?>[] parts = this.getParts();
            for (int i : compound.getIntArray("DisabledMultiparts")) {
                parts[i].setEnabled(false);
            }
        }
        INVULNERABLE.set((Entity)this, this.isInvulnerable());
    }

    public void tick() {
        super.tick();
        this.updateMultipartPositions();
    }

    protected boolean shouldDropLoot() {
        return super.shouldDropLoot() && this.hasDrops;
    }

    @Override
    public AoAEntityPart<?>[] getParts() {
        return this.parts;
    }

    public boolean isMultipartEntity() {
        return this.isMultipartActive();
    }

    public void refreshDimensions() {
        super.refreshDimensions();
        this.refreshMultipartDimensions();
    }

    @Override
    public void setParts(AoAEntityPart<?> ... parts) {
        if (this.getParts().length > 0) {
            throw new IllegalStateException("Cannot add more parts after having already done so!");
        }
        this.parts = parts;
        this.defineParts(ENTITY_COUNTER, this::setId, parts);
    }

    public void setId(int id) {
        super.setId(id);
        this.setMultipartIds(id);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

