/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;

public abstract class AoAMeleeMob<T extends AoAMeleeMob<T>>
extends AoAMonster<T> {
    protected double attackReach = DEFAULT_ATTACK_REACH + (double)this.getEyeHeight() / 3.6 * 0.25;

    protected AoAMeleeMob(EntityType<? extends AoAMeleeMob> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public int calculateKillXp() {
        return !this.hasDrops ? 0 : (int)(5.0 + (this.getAttributeValue(Attributes.MAX_HEALTH) + this.getAttributeValue(Attributes.ARMOR) * 1.75 + this.getAttributeValue(Attributes.ARMOR_TOUGHNESS) * 1.5 + this.getAttributeValue(Attributes.ATTACK_DAMAGE) * 2.0) / 10.0);
    }

    public BrainActivityGroup<? extends T> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration() + 2)});
    }

    protected double getAttackReach() {
        return this.attackReach;
    }

    protected AABB getAttackBoundingBox() {
        AABB boundingBox = this.getBoundingBox();
        double reach = this.getAttackReach();
        if (this.getVehicle() != null) {
            AABB vehicleBounds = this.getVehicle().getBoundingBox();
            boundingBox = new AABB(Math.min(boundingBox.minX, vehicleBounds.minX), boundingBox.minY, Math.min(boundingBox.minZ, vehicleBounds.minZ), Math.max(boundingBox.maxX, vehicleBounds.maxX), boundingBox.maxY, Math.max(boundingBox.maxZ, vehicleBounds.maxZ));
        }
        return boundingBox.inflate(reach, 0.0, reach);
    }
}

