/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AoAAmbientNPC
extends PathfinderMob
implements Npc,
GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private EntityDataHolder<?>[] dataParams;

    public AoAAmbientNPC(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        if (this.dataParams == null) {
            this.dataParams = new EntityDataHolder[0];
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        for (EntityDataHolder<?> dataHolder : this.dataParams) {
            if (dataHolder.checkSync((Entity)this, key)) break;
        }
    }

    protected final void registerDataParams(SynchedEntityData.Builder builder, EntityDataHolder<?> ... params) {
        EntityDataHolder[] newArray = new EntityDataHolder[this.dataParams.length + params.length];
        System.arraycopy(this.dataParams, 0, newArray, 0, this.dataParams.length);
        System.arraycopy(params, 0, newArray, this.dataParams.length, params.length);
        for (EntityDataHolder<?> param : params) {
            param.defineDefault(builder);
        }
        this.dataParams = newArray;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, AoAMeleeMob.class, 8.0f, 0.8, 1.0));
        this.goalSelector.addGoal(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return null;
    }

    public RandomUtil.EasyRandom rand() {
        return new RandomUtil.EasyRandom(this.random);
    }

    @Nullable
    protected abstract String getInteractMessage(ItemStack var1);

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType reason) {
        return this.checkSpawnChance(reason) && this.isValidLightLevel(reason) && this.canSpawnAt(reason, world.getBlockState(this.blockPosition().below()));
    }

    protected boolean canSpawnAt(MobSpawnType reason, BlockState blockState) {
        return reason == MobSpawnType.SPAWNER || blockState.isValidSpawn((BlockGetter)this.level(), this.blockPosition(), this.getType());
    }

    protected int getSpawnChanceFactor() {
        return 1;
    }

    private boolean checkSpawnChance(MobSpawnType reason) {
        return EntityUtil.isNaturalSpawnReason(reason) || this.getSpawnChanceFactor() <= 1 || this.random.nextInt(this.getSpawnChanceFactor()) == 0;
    }

    protected boolean isValidLightLevel(MobSpawnType reason) {
        if (!WorldUtil.isWorld(this.level(), AoADimensions.OVERWORLD)) {
            return true;
        }
        BlockPos blockpos = BlockPos.containing((double)this.getX(), (double)this.getBoundingBox().minY, (double)this.getZ());
        if (this.level().getBrightness(LightLayer.SKY, blockpos) > this.random.nextInt(32)) {
            return true;
        }
        int light = this.level().isThundering() ? this.level().getMaxLocalRawBrightness(blockpos, 10) : this.level().getMaxLocalRawBrightness(blockpos);
        return light > this.random.nextInt(8);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        String msg;
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.getItem() == Items.NAME_TAG) {
            heldStack.interactLivingEntity(player, (LivingEntity)this, hand);
            return InteractionResult.SUCCESS;
        }
        if (!this.level().isClientSide && hand == InteractionHand.MAIN_HAND && (msg = this.getInteractMessage(heldStack)) != null) {
            PlayerUtil.notifyPlayer(player, (Component)Component.translatable((String)msg).withStyle(ChatFormatting.GRAY));
        }
        return super.mobInteract(player, hand);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

