/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.animal;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class ShinySquidEntity
extends Squid {
    public ShinySquidEntity(EntityType<? extends ShinySquidEntity> entityType, Level world) {
        super(entityType, world);
    }

    public void die(DamageSource source) {
        Entity killer;
        super.die(source);
        if (!this.isRemoved() && this.dead && (killer = source.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)killer;
            if (player.fishing != null && player.fishing.getHookedIn() == this) {
                PlayerUtil.givePartialLevelToPlayer(player, (AoASkill)AoASkills.HAULING.get(), 0.1f, false);
            }
        }
    }

    public static SpawnPlacements.SpawnPredicate<LivingEntity> spawnRules() {
        return new AoAEntitySpawnPlacements.SpawnBuilder(GlowSquid::checkGlowSquidSpawnRules).spawnChance(0.001f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<ShinySquidEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(15.0).swimSpeedMod(1.1f).followRange(16.0);
    }
}

