/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.animal;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.content.entity.base.AoAAnimalOld;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class CreepCowEntity
extends AoAAnimalOld {
    public CreepCowEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.getItem() == Items.BUCKET) {
            if (!player.isCreative()) {
                heldStack.shrink(1);
            }
            WorldUtil.createExplosion((Entity)this, this.level(), this.getX(), this.getY(), this.getZ(), 1.5f, Level.ExplosionInteraction.NONE);
            if (player instanceof ServerPlayer) {
                AdvancementUtil.grantCriterion((ServerPlayer)player, AdventOfAscension.id("creeponia/worst_farmer_ever"), "creep_cow_milk");
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    protected boolean isBreedable() {
        return true;
    }

    @Override
    @Nullable
    protected Item getTemptItem() {
        return Items.GUNPOWDER;
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }
}

