/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.trader;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.tslat.aoa3.content.entity.base.AoATrader;

public class TraderPlayerTradeGoal
extends Goal {
    private final AoATrader trader;

    public TraderPlayerTradeGoal(AoATrader trader) {
        this.trader = trader;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.trader.isAlive() || this.trader.isInWater() || !this.trader.onGround() || this.trader.hurtMarked) {
            return false;
        }
        Player customer = this.trader.getTradingPlayer();
        if (customer == null || this.trader.distanceToSqr((Entity)customer) > 16.0) {
            return false;
        }
        return customer.containerMenu != null;
    }

    public void start() {
        this.trader.getNavigation().stop();
    }

    public void stop() {
        this.trader.setTradingPlayer(null);
    }
}

