/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.movehelper;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.AABB;

public class RoamingFlightMovementController
extends MoveControl {
    private final Mob taskOwner;
    private int courseChangeCooldown;

    public RoamingFlightMovementController(Mob creature) {
        super(creature);
        this.taskOwner = creature;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            double distanceX = this.wantedX - this.taskOwner.getX();
            double distanceY = this.wantedY - this.taskOwner.getY();
            double distanceZ = this.wantedZ - this.taskOwner.getZ();
            double distance = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
            if (this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.taskOwner.getRandom().nextInt(5) + 2;
                if (!this.doesPathCollide(this.wantedX / (distance = Math.sqrt(distance)), this.wantedY / distance, this.wantedZ / distance, distance)) {
                    this.taskOwner.setDeltaMovement(this.taskOwner.getDeltaMovement().add(distanceX / distance * 0.1, distanceY / distance * 0.1, distanceZ / distance * 0.1));
                } else {
                    this.operation = MoveControl.Operation.WAIT;
                }
            }
        }
    }

    public boolean doesPathCollide(double posX, double posY, double posZ, double distance) {
        double d0 = (posX - this.taskOwner.getX()) / distance;
        double d1 = (posY - this.taskOwner.getY()) / distance;
        double d2 = (posZ - this.taskOwner.getZ()) / distance;
        AABB collisionBox = this.taskOwner.getBoundingBox();
        int i = 1;
        while ((double)i < distance) {
            collisionBox = collisionBox.move(d0, d1, d2);
            if (!this.taskOwner.level().noCollision((Entity)this.taskOwner)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

