/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.movehelper;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class AirborneMoveControl
extends MoveControl {
    private final int maxTurn;
    private final boolean hoversInPlace;

    public AirborneMoveControl(Mob mob, int maxTurn, boolean hoversInPlace) {
        super(mob);
        this.maxTurn = maxTurn;
        this.hoversInPlace = hoversInPlace;
    }

    public void strafe(float pForward, float pStrafe) {
        this.operation = MoveControl.Operation.STRAFE;
        this.strafeForwards = pForward;
        this.strafeRight = pStrafe;
        this.speedModifier = 0.5;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.STRAFE) {
            this.mob.setNoGravity(true);
            this.operation = MoveControl.Operation.WAIT;
            float moveSpeed = (float)(this.speedModifier * this.mob.getAttributeValue(this.mob.onGround() ? Attributes.MOVEMENT_SPEED : Attributes.FLYING_SPEED));
            this.mob.setSpeed(moveSpeed);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
        } else if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.mob.setNoGravity(true);
            this.operation = MoveControl.Operation.WAIT;
            double distX = this.wantedX - this.mob.getX();
            double distY = this.wantedY - this.mob.getY();
            double distZ = this.wantedZ - this.mob.getZ();
            double distSq = distX * distX + distY * distY + distZ * distZ;
            if (distSq < 2.5E-7) {
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
                return;
            }
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), (float)(Mth.atan2((double)distZ, (double)distX) * 57.2957763671875) - 90.0f, 90.0f));
            float moveSpeed = (float)(this.speedModifier * this.mob.getAttributeValue(this.mob.onGround() ? Attributes.MOVEMENT_SPEED : Attributes.FLYING_SPEED));
            double lateralDist = Math.sqrt(distX * distX + distZ * distZ);
            this.mob.setSpeed(moveSpeed);
            if (Math.abs(distY) > (double)1.0E-5f || Math.abs(lateralDist) > (double)1.0E-5f) {
                float angle = (float)(-(Mth.atan2((double)distY, (double)lateralDist) * 57.2957763671875));
                this.mob.setXRot(this.rotlerp(this.mob.getXRot(), angle, this.maxTurn));
                this.mob.setYya(distY > 0.0 ? moveSpeed : -moveSpeed);
            }
        } else {
            if (!this.hoversInPlace) {
                this.mob.setNoGravity(false);
            }
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }
}

