/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class TelegraphedRangedAttackGoal<T extends Mob>
extends Goal {
    private final T taskOwner;
    private int attackCooldownMin = 20;
    private int attackCooldownMax = 40;
    private float speedModifier = 1.0f;
    private float attackRadius = 32.0f;
    private int preAttackTime = 0;
    public int attackCooldownTimer;
    private LivingEntity target = null;
    private int attackTime = 1;
    private int seeTime;

    public TelegraphedRangedAttackGoal(T taskOwner) {
        this.taskOwner = taskOwner;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public TelegraphedRangedAttackGoal<T> moveSpeedMod(float mod) {
        this.speedModifier = mod;
        return this;
    }

    public TelegraphedRangedAttackGoal<T> attackFrequency(int min, int max) {
        this.attackCooldownMin = min;
        this.attackCooldownMax = max;
        return this;
    }

    public TelegraphedRangedAttackGoal<T> windUpTime(int ticks) {
        this.preAttackTime = ticks;
        return this;
    }

    public TelegraphedRangedAttackGoal<T> targetRadius(float radius) {
        this.attackRadius = radius;
        return this;
    }

    public boolean canUse() {
        LivingEntity target = this.taskOwner.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        this.target = target;
        return true;
    }

    public void start() {
        this.attackCooldownTimer = 0;
    }

    public boolean canContinueToUse() {
        return this.canUse() || !this.taskOwner.getNavigation().isDone();
    }

    public void stop() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = 1;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        double targetDistance = this.taskOwner.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean canSeeTarget = this.taskOwner.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = canSeeTarget ? ++this.seeTime : 0;
        if (!(targetDistance > (double)this.attackRadius * (double)this.attackRadius) && this.seeTime >= 5) {
            this.taskOwner.getNavigation().stop();
        } else {
            this.taskOwner.getNavigation().moveTo((Entity)this.target, (double)this.speedModifier);
        }
        this.taskOwner.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime <= 0 && this.attackTime >= -this.preAttackTime) {
            if (!canSeeTarget) {
                return;
            }
            if (this.attackTime == 0) {
                this.taskOwner.swing(InteractionHand.MAIN_HAND);
            }
            if (this.attackTime == -this.preAttackTime) {
                float distMod = (float)Math.sqrt(targetDistance) / this.attackRadius;
                float distFactor = Mth.clamp((float)distMod, (float)0.1f, (float)1.0f);
                ((RangedAttackMob)this.taskOwner).performRangedAttack(this.target, distFactor);
                this.attackTime = Mth.floor((float)(distMod * (float)(this.attackCooldownMax - this.attackCooldownMin) + (float)this.attackCooldownMin));
            }
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(targetDistance) / (double)this.attackRadius), (double)this.attackCooldownMin, (double)this.attackCooldownMax));
        }
    }
}

