/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.EnumSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.levelgen.Heightmap;

public class RandomFlyingGoal
extends Goal {
    private final Mob taskOwner;
    private final boolean maintainTarget;

    public RandomFlyingGoal(Mob creature, boolean maintainTarget) {
        this.taskOwner = creature;
        this.maintainTarget = maintainTarget;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        double distanceZ;
        double distanceY;
        MoveControl moveHelper = this.taskOwner.getMoveControl();
        if (!moveHelper.hasWanted()) {
            return true;
        }
        if (this.maintainTarget && this.taskOwner.getTarget() != null) {
            return false;
        }
        if (this.taskOwner.onGround()) {
            return true;
        }
        double distanceX = moveHelper.getWantedX() - this.taskOwner.getX();
        double distanceSquared = distanceX * distanceX + (distanceY = moveHelper.getWantedY() - this.taskOwner.getY()) * distanceY + (distanceZ = moveHelper.getWantedZ() - this.taskOwner.getZ()) * distanceZ;
        return distanceSquared < 1.0 || distanceSquared > 3600.0;
    }

    public boolean canContinueToUse() {
        return !this.taskOwner.getNavigation().isDone() && !this.taskOwner.isVehicle();
    }

    public void start() {
        RandomSource rand = this.taskOwner.getRandom();
        float heightMod = (float)(this.taskOwner.getY() + 1.0) / (float)(this.taskOwner.level().getHeight(Heightmap.Types.MOTION_BLOCKING, (int)this.taskOwner.getX(), (int)this.taskOwner.getZ()) + 10);
        double targetX = this.taskOwner.getX() + (double)((rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
        double targetY = this.taskOwner.getY() + (double)((rand.nextFloat() * 2.0f - heightMod) * 16.0f);
        double targetZ = this.taskOwner.getZ() + (double)((rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
        this.taskOwner.getMoveControl().setWantedPosition(targetX, targetY, targetZ, 1.0);
    }
}

