/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.ai.goal.Goal;

public class MultiTypeAttackGoal
extends Goal {
    private final List<Goal> goals;
    private final Object2IntFunction<Goal> goalSelector;
    private Goal currentGoal;
    private int currentGoalIndex = 0;
    private Consumer<Goal> goalChangeConsumer = null;

    public MultiTypeAttackGoal(Object2IntFunction<Goal> goalSelector, Goal goal, Goal ... otherGoals) {
        this.goals = new ArrayList<Goal>(otherGoals.length + 1);
        this.goalSelector = goalSelector;
        this.goals.add(goal);
        this.goals.addAll(Arrays.asList(otherGoals));
        this.currentGoal = goal;
    }

    public MultiTypeAttackGoal onChange(Consumer<Goal> goalChangeConsumer) {
        this.goalChangeConsumer = goalChangeConsumer;
        return this;
    }

    public boolean canUse() {
        return this.currentGoal.canUse();
    }

    public boolean canContinueToUse() {
        if (this.checkAndSwitchGoal()) {
            return false;
        }
        return this.currentGoal.canContinueToUse();
    }

    public boolean isInterruptable() {
        return this.currentGoal.isInterruptable();
    }

    public void start() {
        this.currentGoal.start();
    }

    public void stop() {
        this.currentGoal.stop();
    }

    public boolean requiresUpdateEveryTick() {
        return this.currentGoal.requiresUpdateEveryTick();
    }

    public void tick() {
        this.currentGoal.tick();
    }

    public void setFlags(EnumSet<Goal.Flag> flagSet) {
        this.currentGoal.setFlags(flagSet);
    }

    public EnumSet<Goal.Flag> getFlags() {
        this.checkAndSwitchGoal();
        return this.currentGoal.getFlags();
    }

    protected int adjustedTickDelay(int ticks) {
        return this.currentGoal.requiresUpdateEveryTick() ? ticks : MultiTypeAttackGoal.reducedTickDelay((int)ticks);
    }

    private boolean checkAndSwitchGoal() {
        int selectedGoal = (Integer)this.goalSelector.apply((Object)this.currentGoal);
        if (selectedGoal == this.currentGoalIndex) {
            return false;
        }
        this.currentGoal.stop();
        this.currentGoal = this.goals.get(selectedGoal);
        this.currentGoalIndex = selectedGoal;
        if (this.goalChangeConsumer != null) {
            this.goalChangeConsumer.accept(this.currentGoal);
        }
        return true;
    }
}

