/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.tslat.aoa3.content.entity.base.AoAFlyingRangedMob;

public class FlyingRangedAttackGoal
extends Goal {
    private final AoAFlyingRangedMob taskOwner;
    private final int attackCooldownMin;
    private final int attackCooldownMax;
    public int attackCooldownTimer;

    public FlyingRangedAttackGoal(AoAFlyingRangedMob creature, int attackCooldownMin, int attackCooldownMax) {
        this.taskOwner = creature;
        this.attackCooldownMin = attackCooldownMin;
        this.attackCooldownMax = Math.max(attackCooldownMin + 1, attackCooldownMax);
    }

    public boolean canUse() {
        return this.taskOwner.getTarget() != null;
    }

    public void start() {
        this.attackCooldownTimer = 0;
    }

    public void tick() {
        LivingEntity target = this.taskOwner.getTarget();
        if (target.distanceToSqr((Entity)this.taskOwner) < 4096.0 && this.taskOwner.hasLineOfSight((Entity)target)) {
            ++this.attackCooldownTimer;
            if (this.attackCooldownTimer == this.attackCooldownMin - this.taskOwner.getPreAttackTime()) {
                this.taskOwner.swing(InteractionHand.MAIN_HAND);
            }
            if (this.attackCooldownTimer >= this.attackCooldownMin) {
                this.taskOwner.performRangedAttack(target, 0.0f);
                this.attackCooldownTimer = -this.taskOwner.getRandom().nextInt(this.attackCooldownMax - this.attackCooldownMin);
            }
        } else if (this.attackCooldownTimer > 0) {
            --this.attackCooldownTimer;
        }
    }
}

