/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class FlyingLookRandomlyGoal
extends Goal {
    private final Mob taskOwner;

    public FlyingLookRandomlyGoal(Mob creature) {
        this.taskOwner = creature;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return true;
    }

    public void tick() {
        if (this.taskOwner.getTarget() == null) {
            this.taskOwner.setYRot(-((float)Mth.atan2((double)this.taskOwner.getDeltaMovement().x(), (double)this.taskOwner.getDeltaMovement().z())) * 57.295776f);
            this.taskOwner.yBodyRot = this.taskOwner.getYRot();
        } else {
            LivingEntity target = this.taskOwner.getTarget();
            if (target.distanceToSqr((Entity)this.taskOwner) < 4096.0) {
                double vecX = target.getX() - this.taskOwner.getX();
                double vecZ = target.getZ() - this.taskOwner.getZ();
                this.taskOwner.setYRot(-((float)Mth.atan2((double)vecX, (double)vecZ)) * 57.295776f);
                this.taskOwner.yBodyRot = this.taskOwner.getYRot();
            }
        }
    }
}

