/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.EnumSet;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.content.entity.ai.ExtendedGoal;
import net.tslat.smartbrainlib.util.RandomUtil;

public class ExtendedMeleeAttackGoal<T extends Mob>
extends ExtendedGoal<T> {
    protected double speedModifier = 1.0;
    protected boolean ignoreLineOfSight = false;
    protected double attackReach;
    protected IntProvider attackInterval = ConstantInt.of((int)20);
    protected Path currentPath;
    protected Vec3 targetLocation;
    protected int newPathCooldown;
    protected int attackCooldown;
    protected long goalTimeoutCounter;

    public ExtendedMeleeAttackGoal(T entity) {
        super(entity);
        this.attackReach = (double)entity.getBbWidth() * 1.75 + (double)entity.getEyeHeight() / 3.6 * 0.25;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public ExtendedMeleeAttackGoal<T> speedModifier(double modifier) {
        this.speedModifier = modifier;
        return this;
    }

    public ExtendedMeleeAttackGoal<T> ignoreLineOfSight() {
        this.ignoreLineOfSight = true;
        return this;
    }

    public ExtendedMeleeAttackGoal<T> attackReach(double reach) {
        this.attackReach = reach;
        return this;
    }

    public ExtendedMeleeAttackGoal<T> attackInterval(IntProvider tickValueProvider) {
        this.attackInterval = tickValueProvider;
        return this;
    }

    @Override
    public boolean canUse() {
        if (!super.canUse()) {
            return false;
        }
        long gameTime = this.entity.level().getGameTime();
        if (gameTime - this.goalTimeoutCounter < 20L) {
            return false;
        }
        if (this.entity.level().getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        this.goalTimeoutCounter = gameTime;
        LivingEntity target = this.entity.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        this.currentPath = this.entity.getNavigation().createPath((Entity)target, 0);
        if (this.currentPath != null) {
            return true;
        }
        return this.getAttackReachSqr(target) >= this.entity.distanceToSqr(target.getX(), target.getY(), target.getZ());
    }

    @Override
    public void start() {
        super.start();
        this.entity.getNavigation().moveTo(this.currentPath, this.speedModifier);
        this.entity.setAggressive(true);
        this.newPathCooldown = 0;
        this.attackCooldown = 0;
    }

    @Override
    public boolean canContinueToUse() {
        if (!super.canContinueToUse()) {
            return false;
        }
        LivingEntity target = this.entity.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (target.isSpectator() || target instanceof Player && ((Player)target).isCreative()) {
            return false;
        }
        if (this.isTelegraphingAction()) {
            return true;
        }
        if (!this.ignoreLineOfSight) {
            return !this.entity.getNavigation().isDone();
        }
        return this.entity.isWithinRestriction(target.blockPosition());
    }

    @Override
    public void tick() {
        super.tick();
        LivingEntity target = this.entity.getTarget();
        double targetDistance = this.entity.distanceToSqr(target.getX(), target.getY(), target.getZ());
        if (this.newPathCooldown > 0) {
            --this.newPathCooldown;
        }
        this.entity.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        if (this.newPathCooldown <= 0 && (this.ignoreLineOfSight || this.entity.getSensing().hasLineOfSight((Entity)target)) && (this.targetLocation == null || target.distanceToSqr(this.targetLocation) >= 1.0 || RandomUtil.oneInNChance((int)20))) {
            this.targetLocation = target.position();
            this.newPathCooldown = RandomUtil.randomNumberBetween((int)4, (int)11);
            if (targetDistance > 256.0) {
                this.newPathCooldown += 5;
                if (targetDistance > 1024.0) {
                    this.newPathCooldown += 5;
                }
            }
            if (!this.entity.getNavigation().moveTo((Entity)target, this.speedModifier)) {
                this.newPathCooldown += 15;
            }
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        this.checkAndPerformAttack(target, targetDistance);
    }

    @Override
    public void stop() {
        super.stop();
        this.entity.setAggressive(false);
        this.entity.getNavigation().stop();
    }

    protected void checkAndPerformAttack(LivingEntity target, double sqrDistToTarget) {
        if (sqrDistToTarget <= this.getAttackReachSqr(target)) {
            if (this.attackCooldown <= 0) {
                this.attackCooldown = this.attackInterval.sample((RandomSource)RandomUtil.RANDOM);
                this.startTelegraphingNextAction();
                this.entity.swing(InteractionHand.MAIN_HAND);
                return;
            }
            if (this.hasActionTelegraphFinished()) {
                this.entity.doHurtTarget((Entity)target);
                this.resetActionTelegraph();
            }
        } else {
            this.resetActionTelegraph();
        }
    }

    protected double getAttackReachSqr(LivingEntity target) {
        double targetBBOffset = (double)target.getBbWidth() * 0.5;
        return this.attackReach * this.attackReach + targetBBOffset * targetBBOffset;
    }
}

