/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class CompletePanicGoal
extends Goal {
    protected final PathfinderMob taskOwner;
    protected final int timeToPanic;
    protected int panicTimer;
    protected final double speed;
    protected double randomTargetX;
    protected double randomTargetY;
    protected double randomTargetZ;

    public CompletePanicGoal(PathfinderMob creature, int timeToPanic, double speed) {
        this.taskOwner = creature;
        this.timeToPanic = timeToPanic;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.taskOwner.getLastHurtByMob() != null && this.getRandomPosition();
    }

    public boolean isInterruptable() {
        return false;
    }

    protected boolean getRandomPosition() {
        Vec3 targetPos = DefaultRandomPos.getPos((PathfinderMob)this.taskOwner, (int)20, (int)4);
        if (targetPos != null) {
            this.randomTargetX = targetPos.x;
            this.randomTargetY = targetPos.y;
            this.randomTargetZ = targetPos.z;
            return true;
        }
        return false;
    }

    public void stop() {
        this.panicTimer = 0;
    }

    public void start() {
        this.taskOwner.getNavigation().moveTo(this.randomTargetX, this.randomTargetY, this.randomTargetZ, this.speed);
    }

    public boolean canContinueToUse() {
        return this.panicTimer < this.timeToPanic;
    }

    public void tick() {
        ++this.panicTimer;
        if (this.taskOwner.getNavigation().isDone() && this.getRandomPosition()) {
            this.taskOwner.getNavigation().moveTo(this.randomTargetX, this.randomTargetY, this.randomTargetZ, this.speed);
        }
    }
}

