/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.plants;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;

public class StackablePlant
extends Block
implements IShearable {
    protected Supplier<? extends StackablePlant> hatBlock;
    protected Supplier<? extends StackablePlant> stemBlock = () -> this;

    public StackablePlant(BlockBehaviour.Properties properties) {
        super(properties);
        this.hatBlock = () -> this;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos newPos = pos.above();
        BlockState blockState = world.getBlockState(newPos);
        Block block = blockState.getBlock();
        while (block == this.stemBlock.get() || block == this.hatBlock.get()) {
            world.setBlock(newPos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, newPos, Block.getId((BlockState)blockState));
            if (!world.isClientSide() && !player.isCreative()) {
                StackablePlant.dropResources((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
                StackablePlant.dropResources((BlockState)blockState, (Level)world, (BlockPos)newPos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
            newPos = newPos.above();
            blockState = world.getBlockState(newPos);
            block = blockState.getBlock();
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState targetState = level.getBlockState(pos.below());
        return targetState.getBlock() == this.stemBlock.get() || targetState.canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state) != TriState.FALSE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, pos, facingPos);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.AIR && !this.hasCollision || super.isPathfindable(state, type);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return ObjectArrayList.of((Object[])new ItemStack[]{this.asItem().getDefaultInstance()});
    }
}

