/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.plants;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.tslat.aoa3.content.block.generation.plants.GrowablePlantBlock;

public class GrowableDoublePlantBlock
extends GrowablePlantBlock {
    private final Supplier<? extends DoublePlantBlock> grownPlant;

    public GrowableDoublePlantBlock(BlockBehaviour.Properties properties, Supplier<? extends DoublePlantBlock> grownPlant) {
        super(properties);
        this.grownPlant = grownPlant;
    }

    @Override
    int getGrowHeight(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        return 2;
    }

    @Override
    void growPlant(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, this.mergeWaterlogging((Level)level, (BlockState)this.getGrownPlantForHeight(level, random, pos, state, 0).setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), pos), 2);
        level.setBlock(pos.above(), this.mergeWaterlogging((Level)level, (BlockState)this.getGrownPlantForHeight(level, random, pos, state, 1).setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), pos), 2);
    }

    @Override
    BlockState getGrownPlantForHeight(ServerLevel level, RandomSource random, BlockPos pos, BlockState state, int heightStage) {
        return this.grownPlant.get().defaultBlockState();
    }
}

