/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.misc;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DeadBranchBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static IntegerProperty VARIANT = IntegerProperty.create((String)"variant", (int)1, (int)3);
    private static final VoxelShape NORTH_SOUTH_SHAPE = Shapes.box((double)0.49f, (double)0.0, (double)0.0, (double)0.51f, (double)1.0, (double)1.0);
    private static final VoxelShape EAST_WEST_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.49f, (double)1.0, (double)1.0, (double)0.51f);

    public DeadBranchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue((Property)VARIANT, (Comparable)Integer.valueOf(1)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        RandomSource rand = context.getLevel().getRandom();
        rand.setSeed(context.getClickedPos().asLong());
        return state == null ? null : (BlockState)state.setValue((Property)VARIANT, (Comparable)Integer.valueOf(rand.nextInt(1, 3)));
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return DeadBranchBlock.simpleCodec(DeadBranchBlock::new);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return 5;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return 20;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT, FACE});
    }
}

