/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.smartbrainlib.util.RandomUtil;

public class BaronLooseSand
extends ColoredFallingBlock {
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);

    public BaronLooseSand(BlockBehaviour.Properties properties) {
        super(new ColorRGBA(7424330), properties);
    }

    protected VoxelShape getOcclusionShape(BlockState blockState, BlockGetter blockGetter, BlockPos pos) {
        return Shapes.empty();
    }

    protected VoxelShape getVisualShape(BlockState blockState, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return Shapes.empty();
    }

    protected VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (collisionContext instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)collisionContext).getEntity()) != null) {
            if (entity.fallDistance > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            if (entity instanceof FallingBlockEntity || BaronLooseSand.canEntityWalkOnLooseSand(entity) && collisionContext.isAbove(Shapes.block(), pos, false) && !collisionContext.isDescending()) {
                return super.getCollisionShape(blockState, blockGetter, pos, collisionContext);
            }
        }
        return Shapes.empty();
    }

    public void fallOn(Level level, BlockState blockState, BlockPos pos, Entity entity, float fallDistance) {
        if (fallDistance >= 4.0f && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LivingEntity.Fallsounds fallFound = livingEntity.getFallSounds();
            entity.playSound(fallDistance < 7.0f ? fallFound.small() : fallFound.big(), 1.0f, 1.0f);
        }
    }

    protected void entityInside(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.getInBlockState().is((Block)this)) {
            entity.makeStuckInBlock(blockState, new Vec3((double)0.8f, (double)0.2f, (double)0.8f));
            if (!level.isClientSide && BlockPos.containing((Position)entity.getEyePosition()).equals((Object)pos)) {
                DamageUtil.safelyDealDamage(level.damageSources().inWall(), entity, 1.0f);
            }
            if (level.isClientSide && (entity.xOld != entity.getX() || entity.zOld != entity.getZ()) && level.getRandom().nextBoolean()) {
                ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)AoABlocks.BARON_LOOSE_SAND.get()).defaultBlockState()), (Entity)entity).power(new Vec3(RandomUtil.randomScaledGaussianValue((double)0.0833333358168602), (double)0.05f, RandomUtil.randomScaledGaussianValue((double)0.0833333358168602))).spawnParticles(level);
            }
        }
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathType) {
        return true;
    }

    public static boolean canEntityWalkOnLooseSand(Entity entity) {
        LivingEntity livingEntity;
        if (entity.getType().is(AoATags.Entities.LOOSE_SAND_WALKABLE_MOBS)) {
            return true;
        }
        return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getItemBySlot(EquipmentSlot.FEET).canWalkOnPowderedSnow(livingEntity);
    }
}

