/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.leaves;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.Nullable;

public class AoALeavesBlock
extends Block
implements SimpleWaterloggedBlock,
IShearable {
    public static final int DECAYS_AT_DIST = 15;
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"distance", (int)1, (int)15);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public AoALeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(15))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 30;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)DISTANCE) == 15 && (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.shouldDecay(state)) {
            AoALeavesBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
            level.removeBlock(pos, false);
        }
    }

    protected boolean shouldDecay(BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false && (Integer)state.getValue((Property)DISTANCE) == 15;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource pRandom) {
        level.setBlock(pos, AoALeavesBlock.updateLeafDistance(state, (LevelAccessor)level, pos), 3);
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return 1;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbour, LevelAccessor level, BlockPos pos, BlockPos neighbourPos) {
        int dist;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            FlowingFluid fluid = level instanceof WorldGenRegion ? Fluids.WATER : level.getFluidState(pos).getType();
            level.scheduleTick(pos, (Fluid)fluid, fluid.getTickDelay((LevelReader)level));
        }
        if ((dist = AoALeavesBlock.getLeafDistance(neighbour)) > 1 || (Integer)state.getValue((Property)DISTANCE) != dist) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return state;
    }

    public static int getLeafDistance(BlockState neighbourState) {
        if (neighbourState.is(BlockTags.LOGS)) {
            return 0;
        }
        return neighbourState.hasProperty((Property)DISTANCE) ? (Integer)neighbourState.getValue((Property)DISTANCE) : 15;
    }

    protected static BlockState updateLeafDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int minDist = 15;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            checkPos.setWithOffset((Vec3i)pos, direction);
            minDist = Math.min(minDist, AoALeavesBlock.getLeafDistance(level.getBlockState((BlockPos)checkPos)) + 1);
            if (minDist == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(minDist));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!level.isRainingAt(pos.above()) || random.nextInt(15) > 0) {
            return;
        }
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (!belowState.canOcclude() || !belowState.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP)) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)ParticleTypes.DRIPPING_WATER);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        return AoALeavesBlock.updateLeafDistance((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(clickedPos).getType() == Fluids.WATER)), (LevelAccessor)level, clickedPos);
    }
}

