/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.grass;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.content.block.generation.grass.AoAGrassBlock;

public class UpsideDownGrassBlock
extends AoAGrassBlock {
    public UpsideDownGrassBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> soilBlock, boolean growsInDark) {
        super(properties, soilBlock);
    }

    @Override
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
    }

    public boolean hasSufficientLight(BlockState grassState, Level world, BlockPos grassPos) {
        if (world.dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)AdventOfAscension.id("lelyetia"))) {
            return true;
        }
        BlockPos bottomPos = grassPos.below();
        BlockState bottomBlock = world.getBlockState(bottomPos);
        return LightEngine.getLightBlockInto((BlockGetter)world, (BlockState)grassState, (BlockPos)grassPos, (BlockState)bottomBlock, (BlockPos)bottomPos, (Direction)Direction.DOWN, (int)bottomBlock.getLightBlock((BlockGetter)world, bottomPos)) < world.getMaxLightLevel();
    }

    public boolean canStayGrass(BlockState grassState, Level world, BlockPos grassPos) {
        return this.hasSufficientLight(grassState, world, grassPos) && !world.getFluidState(grassPos.below()).is(FluidTags.WATER);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!this.hasSufficientLight(state, (Level)world, pos)) {
            if (!world.isAreaLoaded(pos, 3)) {
                return;
            }
            world.setBlockAndUpdate(pos, ((Block)this.soilBlock.get()).defaultBlockState());
        } else if (world.getMaxLocalRawBrightness(pos.below()) < 9) {
            BlockState grassState = this.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                BlockPos growPos = pos.offset(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                if (world.getBlockState(growPos).getBlock() != this.soilBlock.get() || !this.canStayGrass(grassState, (Level)world, growPos)) continue;
                world.setBlockAndUpdate(growPos, (BlockState)grassState.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(world.getBlockState(growPos.below()).getBlock() == Blocks.SNOW)));
            }
        }
    }
}

