/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.grass;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LightEngine;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class AoAGrassBlock
extends GrassBlock {
    protected final Supplier<? extends Block> soilBlock;
    protected final ResourceKey<PlacedFeature> bonemealFeature;

    public AoAGrassBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> soilBlock) {
        this(properties, soilBlock, null);
    }

    public AoAGrassBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> soilBlock, @Nullable ResourceKey<PlacedFeature> bonemealFeature) {
        super(properties);
        this.soilBlock = soilBlock;
        this.bonemealFeature = bonemealFeature;
    }

    public Block getSoilBlock() {
        return this.soilBlock.get();
    }

    @Nullable
    protected ResourceKey<PlacedFeature> getBonemealGrowthFeature(LevelReader level, BlockState state, BlockPos pos) {
        return this.bonemealFeature;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return this.getBonemealGrowthFeature(level, state, pos) != null && super.isValidBonemealTarget(level, pos, state);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return this.getBonemealGrowthFeature((LevelReader)level, state, pos) != null;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.checkRevertToSoil(level, state, pos, random)) {
            return;
        }
        this.checkMakeSnowy(level, state, pos, random);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.above();
        ResourceKey<PlacedFeature> bonemealFeatureKey = this.getBonemealGrowthFeature((LevelReader)level, state, pos);
        if (bonemealFeatureKey == null) {
            return;
        }
        Optional boneMealFeature = level.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getHolder(bonemealFeatureKey);
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos adjacentPos = abovePos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.getBlockState((adjacentPos = adjacentPos.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is((Block)this) || level.getBlockState(adjacentPos).isCollisionShapeFullBlock((BlockGetter)level, adjacentPos)) continue block0;
            }
            BlockState adjacentState = level.getBlockState(adjacentPos);
            if (adjacentState.is((Block)this) && random.nextInt(10) == 0) {
                this.performBonemeal(level, random, adjacentPos, adjacentState);
            }
            if (!adjacentState.isAir()) continue;
            if (random.nextInt(8) == 0) {
                List flowerFeatures = ((Biome)level.getBiome(adjacentPos).value()).getGenerationSettings().getFlowerFeatures();
                if (flowerFeatures.isEmpty()) continue;
                ((PlacedFeature)((RandomPatchConfiguration)((ConfiguredFeature)flowerFeatures.get(0)).config()).feature().value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, adjacentPos);
                continue;
            }
            if (!boneMealFeature.isPresent()) continue;
            ((PlacedFeature)((Holder.Reference)boneMealFeature.get()).value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, adjacentPos);
        }
    }

    protected boolean checkRevertToSoil(ServerLevel level, BlockState state, BlockPos pos, RandomSource random) {
        if (AoAGrassBlock.canBeGrass((LevelReader)level, state, pos)) {
            return false;
        }
        if (level.isAreaLoaded(pos, 1)) {
            level.setBlockAndUpdate(pos, this.getSoilBlock().defaultBlockState());
        }
        return true;
    }

    protected boolean checkMakeSnowy(ServerLevel level, BlockState state, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 3)) {
            return false;
        }
        boolean madeSnowy = false;
        if (level.getMaxLocalRawBrightness(pos.above()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos nearbyPos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (!level.getBlockState(nearbyPos).is(this.getSoilBlock()) || !AoAGrassBlock.canSpread((LevelReader)level, this.defaultBlockState(), nearbyPos)) continue;
                level.setBlockAndUpdate(nearbyPos, (BlockState)this.defaultBlockState().setValue((Property)SNOWY, (Comparable)Boolean.valueOf(level.getBlockState(nearbyPos.above()).is(Blocks.SNOW))));
                madeSnowy = true;
            }
        }
        return madeSnowy;
    }

    public static boolean canSpread(LevelReader level, BlockState state, BlockPos pos) {
        return AoAGrassBlock.canBeGrass(level, state, pos) && level.getFluidState(pos.above()).isEmpty();
    }

    public static boolean canBeGrass(LevelReader level, BlockState state, BlockPos pos) {
        BlockPos abovePos = pos.above();
        BlockState aboveState = level.getBlockState(abovePos);
        if (aboveState.is(Blocks.SNOW) && (Integer)aboveState.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (aboveState.getFluidState().getAmount() == 8) {
            return false;
        }
        return LightEngine.getLightBlockInto((BlockGetter)level, (BlockState)state, (BlockPos)pos, (BlockState)aboveState, (BlockPos)abovePos, (Direction)Direction.UP, (int)aboveState.getLightBlock((BlockGetter)level, abovePos)) < level.getMaxLightLevel();
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility ItemAbility2, boolean simulate) {
        return super.getToolModifiedState(state, context, ItemAbility2, simulate);
    }
}

