/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.utility;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredItem;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class TeaSink
extends HorizontalDirectionalBlock {
    public static final BooleanProperty FILLED = BooleanProperty.create((String)"filled");
    private static final VoxelShape BOTTOM_SHAPE = TeaSink.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BOTTOM_SHAPE, (VoxelShape)TeaSink.box((double)6.0, (double)7.0, (double)0.0, (double)10.0, (double)16.0, (double)10.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BOTTOM_SHAPE, (VoxelShape)TeaSink.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)16.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BOTTOM_SHAPE, (VoxelShape)TeaSink.box((double)0.0, (double)7.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BOTTOM_SHAPE, (VoxelShape)TeaSink.box((double)6.0, (double)7.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0));

    public TeaSink(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FILLED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends TeaSink> codec() {
        return TeaSink.simpleCodec(TeaSink::new);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)FILLED)).booleanValue()) {
            if (!stack.is(AoAItems.CUP)) {
                return ItemInteractionResult.FAIL;
            }
            return InventoryUtil.findItem(player, AoAItems.TEA_SHREDDINGS).map(shreddings -> {
                if (player instanceof ServerPlayer) {
                    ServerPlayer pl = (ServerPlayer)player;
                    DeferredItem<Item> tea = AoAItems.TEA;
                    if (InventoryUtil.findItemForConsumption((Player)pl, AoAItems.MYSTIC_SHROOMS, pl.getAbilities().instabuild ? 0 : 1, true)) {
                        tea = AoAItems.FUNGAL_TEA;
                    } else if (InventoryUtil.findItemForConsumption((Player)pl, AoAItems.NATURE_MELON_SLICE, pl.getAbilities().instabuild ? 0 : 1, true)) {
                        tea = AoAItems.NATURE_MELON_SLICE;
                    }
                    if (!pl.getAbilities().instabuild) {
                        ((ItemStack)shreddings.right()).shrink(1);
                        stack.shrink(1);
                    }
                    InventoryUtil.giveItemTo(pl, tea);
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)AoASounds.BLOCK_TEA_SINK_USE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (RandomUtil.oneInNChance((int)7)) {
                        level.setBlockAndUpdate(pos, (BlockState)((Block)AoABlocks.TEA_SINK.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING))));
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }).orElse(ItemInteractionResult.FAIL);
        }
        if (stack.getItem() == Items.WATER_BUCKET) {
            if (player instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                if (!pl.getAbilities().instabuild) {
                    stack.shrink(1);
                    InventoryUtil.giveItemTo(pl, (ItemLike)Items.BUCKET);
                }
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)))).setValue((Property)FILLED, (Comparable)Boolean.valueOf(true)));
                level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)AoASounds.BLOCK_TEA_SINK_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FILLED, (Comparable)Boolean.valueOf(false))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)EntityUtil.getDirectionFacing((Entity)context.getPlayer(), true));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FILLED, HorizontalDirectionalBlock.FACING});
    }
}

