/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.utility;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.menu.InfusedPressMenu;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.block.blockentity.InfusedPressBlockEntity;
import net.tslat.aoa3.library.object.GenericItemStackHandler;
import net.tslat.aoa3.util.InteractionResults;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import org.jetbrains.annotations.Nullable;

public class InfusedPress
extends Block
implements EntityBlock {
    public InfusedPress(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new InfusedPressBlockEntity(pos, state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof InfusedPressBlockEntity) {
                InfusedPressBlockEntity blockEntity2 = (InfusedPressBlockEntity)blockEntity;
                blockEntity2.dropContents();
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level instanceof ServerLevel) {
            BlockEntity blockEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (pos.above().equals((Object)neighborPos) && neighborBlock instanceof PistonHeadBlock && (blockEntity = level.getBlockEntity(pos)) instanceof InfusedPressBlockEntity) {
                InfusedPressBlockEntity press = (InfusedPressBlockEntity)blockEntity;
                BlockState pistonState = level.getBlockState(neighborPos.above());
                boolean compressing = pistonState.getBlock() instanceof PistonBaseBlock;
                if (!compressing && !(pistonState.getBlock() instanceof MovingPistonBlock)) {
                    return;
                }
                if (pistonState.getValue((Property)DirectionalBlock.FACING) != Direction.DOWN) {
                    return;
                }
                if (compressing) {
                    if (press.compress()) {
                        RandomSource rand = level.random;
                        TELParticlePacket packet = new TELParticlePacket();
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)(pos.getY() + 1), (double)((float)pos.getZ() + 0.5f), SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.5f + 0.75f);
                        for (int i = 0; i < 50; ++i) {
                            packet.particle(ParticleBuilder.forRandomPosInCircleRadius((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, press.getItemHandler().getStackInSlot(9)), (Vec3)pos.above(1).getBottomCenter(), (double)0.5).scaleMod(0.5f).velocity(rand.nextGaussian() * (double)0.05f, (double)(rand.nextFloat() * 0.1f), rand.nextGaussian() * (double)0.05f));
                            packet.particle(ParticleBuilder.forRandomPosInCircleRadius((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (Vec3)pos.above(1).getBottomCenter(), (double)0.5).scaleMod(0.25f).lifespan(rand.nextInt(10, 20)).colourOverride(rand.nextInt(125, 175), 0, 0, 255));
                            packet.particle(ParticleBuilder.forRandomPosInCircleRadius((ParticleOptions)ParticleTypes.CRIT, (Vec3)pos.above(1).getBottomCenter(), (double)0.5).scaleMod(0.25f).lifespan(rand.nextInt(3, 15)).velocity(rand.nextGaussian() * (double)0.05f, (double)(rand.nextFloat() * 0.1f), rand.nextGaussian() * (double)0.05f).colourOverride(rand.nextInt(125, 175), 0, 0, 255));
                        }
                        packet.sendToAllPlayersTrackingBlock(serverLevel, pos);
                    }
                } else if (press.decompress()) {
                    level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)(pos.getY() + 1), (double)((float)pos.getZ() + 0.5f), SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof InfusedPressBlockEntity) {
            InfusedPressBlockEntity press = (InfusedPressBlockEntity)blockEntity;
            GenericItemStackHandler itemHandler = press.getItemHandler();
            if (!itemHandler.getStackInSlot(9).isEmpty()) {
                return 15;
            }
            int count = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (!stack.is(AoAItems.COMPRESSED_ITEM) && (!stack.isStackable() || stack.getCount() < stack.getMaxStackSize())) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            InfusedPressMenu.openContainer(pl, pos);
        }
        return InteractionResults.BlockUseWithoutItem.succeedAndSwingArmBothSides(level.isClientSide);
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof InfusedPressBlockEntity) {
            InfusedPressBlockEntity blockEntity2 = (InfusedPressBlockEntity)blockEntity;
            return blockEntity2;
        }
        return null;
    }
}

