/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.utility;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class CrystalExtensionShrine
extends Block {
    public CrystalExtensionShrine(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.getItemInHand(hand).isEmpty() && stack.getItem() == AoAItems.RAINBOW_DRUSE.get()) {
            if (player instanceof ServerPlayer) {
                ItemEntity item;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                List crystalList = level.getEntitiesOfClass(ItemEntity.class, new AABB((double)(pos.getX() - 5), (double)(pos.getY() - 1), (double)(pos.getZ() - 5), (double)(pos.getX() + 5), (double)(pos.getY() + 1), (double)(pos.getZ() + 5)), entity -> CrystalExtensionShrine.isCrystal(entity.getItem().getItem()));
                int count = 0;
                Iterator iterator = crystalList.iterator();
                while (iterator.hasNext() && (count += (item = (ItemEntity)iterator.next()).getItem().getCount()) < 10) {
                }
                if (count < 10) {
                    PlayerUtil.notifyPlayer((Player)serverPlayer, (Component)Component.translatable((String)LocaleUtil.createFeedbackLocaleKey("crystalExtensionShrine.crystals")));
                    return ItemInteractionResult.FAIL;
                }
                for (int i = 10; i > 0; --i) {
                    ItemEntity entity2 = (ItemEntity)crystalList.getFirst();
                    ItemStack entityStack = entity2.getItem();
                    int size = entityStack.getCount();
                    entityStack.shrink(i);
                    if (entityStack.getCount() <= 0) {
                        crystalList.removeFirst();
                    }
                    i -= size - 1;
                }
                if (!serverPlayer.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                InventoryUtil.giveItemTo(serverPlayer, AoAItems.GIANT_CRYSTAL);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static boolean isCrystal(Item item) {
        return item == AoAItems.BLUE_CRYSTAL.get() || item == AoAItems.GREEN_CRYSTAL.get() || item == AoAItems.PURPLE_CRYSTAL.get() || item == AoAItems.RED_CRYSTAL.get() || item == AoAItems.WHITE_CRYSTAL.get() || item == AoAItems.YELLOW_CRYSTAL.get();
    }
}

