/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.portal;

import com.google.common.base.Suppliers;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.world.teleporter.AoAPortal;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import org.jetbrains.annotations.Nullable;

public abstract class PortalBlock
extends Block
implements AoAPortal {
    private static final VoxelShape X_SHAPE = Shapes.create((AABB)new AABB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0));
    private static final VoxelShape Z_SHAPE = Shapes.create((AABB)new AABB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625));
    private final int particleColour;
    private final ResourceKey<Level> dimension;
    private final Supplier<SoundEvent> ambientSound;
    private static final Supplier<Set<Block>> USEABLE_PORTALS = Suppliers.memoize(() -> Set.of((Block)AoABlocks.NETHER_PORTAL.get(), (Block)AoABlocks.NOWHERE_PORTAL.get(), (Block)AoABlocks.PRECASIA_PORTAL.get(), (Block)AoABlocks.BARATHOS_PORTAL.get(), (Block)AoABlocks.LELYETIA_PORTAL.get(), (Block)AoABlocks.DEEPLANDS_PORTAL.get(), (Block)AoABlocks.LBOREAN_PORTAL.get(), (Block)AoABlocks.CELEVE_PORTAL.get(), (Block)AoABlocks.ABYSS_PORTAL.get(), (Block)AoABlocks.DUSTOPIA_PORTAL.get(), (Block)AoABlocks.CRYSTEVIA_PORTAL.get()));

    public PortalBlock(BlockBehaviour.Properties properties, ResourceKey<Level> dimension, int particleColour) {
        this(properties, dimension, particleColour, null);
    }

    public PortalBlock(BlockBehaviour.Properties properties, ResourceKey<Level> dimension, int particleColour, @Nullable Supplier<SoundEvent> ambientSound) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X));
        this.particleColour = particleColour;
        this.dimension = dimension;
        this.ambientSound = ambientSound;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public int getParticleColour(BlockState state) {
        return this.particleColour;
    }

    @Override
    public PortalBlock getPortalBlock() {
        return this;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) == Direction.Axis.Z) {
            return Z_SHAPE;
        }
        return X_SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)EntityUtil.getDirectionFacing((Entity)context.getPlayer(), true).getAxis());
    }

    private boolean isCompatibleNeighbour(Level world, BlockPos pos) {
        BlockState block = world.getBlockState(pos);
        return block.getBlock() == this || !block.isAir();
    }

    public boolean skipRendering(BlockState state, BlockState adjacent, Direction side) {
        if (adjacent.getBlock() == this) {
            switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                case X: {
                    Direction.Axis axis = (Direction.Axis)adjacent.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
                    if (axis != Direction.Axis.X) break;
                    return true;
                }
                case Z: {
                    Direction.Axis axis = (Direction.Axis)adjacent.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
                    if (axis != Direction.Axis.Z) break;
                    return true;
                }
            }
        }
        return false;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.ambientSound != null && random.nextInt(100) == 0 && level.dimension() != this.dimension) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, this.ambientSound.get(), SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        boolean offsetX = !level.getBlockState(pos.west()).is((Block)this) && !level.getBlockState(pos.east()).is((Block)this);
        int particleColour = this.getParticleColour(state);
        for (int i = 0; i < 4; ++i) {
            double posX = (double)pos.getX() + random.nextDouble();
            double posY = (double)pos.getY() + random.nextDouble();
            double posZ = (double)pos.getZ() + random.nextDouble();
            double xVelocity = (random.nextDouble() - 0.5) * 0.5;
            double yVelocity = (random.nextDouble() - 0.5) * 0.5;
            double zVelocity = (random.nextDouble() - 0.5) * 0.5;
            double randomMod = random.nextInt(2) * 2 - 1;
            if (offsetX) {
                posX = (double)((float)pos.getX() + 0.5f) + 0.25 * randomMod;
                xVelocity = random.nextDouble() * 2.0 * randomMod;
            } else {
                posZ = (double)((float)pos.getZ() + 0.5f) + 0.25 * randomMod;
                zVelocity = random.nextDouble() * 2.0 * randomMod;
            }
            ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.PORTAL, (double)posX, (double)posY, (double)posZ).power(new Vec3(xVelocity, yVelocity, zVelocity)).colourOverride(particleColour).spawnParticles(level);
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_AXIS});
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        if (world.isEmptyBlock(pos.above()) || world.isEmptyBlock(pos.below())) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            return;
        }
        switch ((Direction.Axis)world.getBlockState(pos).getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            case Z: {
                if (!world.isEmptyBlock(pos.east()) && !world.isEmptyBlock(pos.west())) break;
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                break;
            }
            case X: {
                if (!world.isEmptyBlock(pos.north()) && !world.isEmptyBlock(pos.south())) break;
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Direction.Axis facing = (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
        switch (facing) {
            case Z: {
                if (this.isCompatibleNeighbour(world, pos.above()) && this.isCompatibleNeighbour(world, pos.below()) && this.isCompatibleNeighbour(world, pos.east()) && this.isCompatibleNeighbour(world, pos.west())) break;
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                break;
            }
            case X: {
                if (this.isCompatibleNeighbour(world, pos.above()) && this.isCompatibleNeighbour(world, pos.below()) && this.isCompatibleNeighbour(world, pos.north()) && this.isCompatibleNeighbour(world, pos.south())) break;
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!USEABLE_PORTALS.get().contains(this)) {
            return;
        }
        if (entity.canUsePortal(false)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        GlobalPos globalPos;
        if (!((Boolean)AoAConfigs.SERVER.allowNonPlayerPortalTravel.get()).booleanValue() && !(entity instanceof ServerPlayer)) {
            return null;
        }
        ResourceKey currentDimension = level.dimension();
        ResourceKey<Level> portalTargetDimension = this.getDimension();
        MinecraftServer server = level.getServer();
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            globalPos = PlayerUtil.getAdventPlayer((ServerPlayer)pl).storage.getPortalReturnFor((ResourceKey<Level>)currentDimension);
        } else {
            globalPos = null;
        }
        Optional<Object> existingLink = Optional.ofNullable(globalPos);
        ServerLevel targetLevel = existingLink.map(link -> server.getLevel(currentDimension != portalTargetDimension ? portalTargetDimension : link.dimension())).orElseGet(() -> server.getLevel(currentDimension == portalTargetDimension ? Level.OVERWORLD : portalTargetDimension));
        if (targetLevel == null) {
            if (currentDimension == Level.OVERWORLD) {
                return null;
            }
            targetLevel = server.overworld();
        }
        return this.getTransitionForPortalLink(targetLevel, entity, Optional.of(pos), AoAPortal.makeSafeCoords((Level)level, (Level)targetLevel, entity.position()), existingLink);
    }

    public DimensionTransition getTransitionForPortalLink(ServerLevel targetLevel, Entity entity, Optional<BlockPos> fromPortal, BlockPos safeCoords, Optional<GlobalPos> existingLink) {
        return AoAPortal.getTransitionForLevel(targetLevel, entity, fromPortal, safeCoords, this, existingLink);
    }
}

