/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.portal;

import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.portal.PortalBlock;
import net.tslat.aoa3.content.world.nowhere.NowhereParkourCourse;
import net.tslat.aoa3.event.dimension.NowhereEvents;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class NowhereActivityPortal
extends PortalBlock {
    private static final EnumProperty<Activity> ACTIVITY = EnumProperty.create((String)"activity", Activity.class);

    public NowhereActivityPortal(BlockBehaviour.Properties properties) {
        super(properties, AoADimensions.NOWHERE, 0);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(ACTIVITY, (Comparable)((Object)Activity.UTILITY)));
    }

    @Override
    public Block getPortalFrame() {
        return (Block)AoABlocks.ANCIENT_TILE_SHRINE.get();
    }

    @Override
    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        ServerPlayer pl;
        if (entity.getVehicle() == null && !entity.isVehicle() && entity instanceof ServerPlayer && WorldUtil.isWorld((pl = (ServerPlayer)entity).level(), AoADimensions.NOWHERE)) {
            if (pl.isOnPortalCooldown()) {
                pl.setPortalCooldown();
                return;
            }
            pl.setPortalCooldown();
            ((Activity)((Object)state.getValue(ACTIVITY))).activate(pl);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVITY});
    }

    @Override
    public int getParticleColour(BlockState state) {
        return switch (((Activity)((Object)state.getValue(ACTIVITY))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 39103;
            case 1 -> 9175295;
            case 2 -> 262388;
            case 3 -> 12449536;
            case 4 -> 0xFFCC00;
            case 5 -> 14711552;
            case 6 -> 0xD30000;
            case 7 -> 0xBA0000;
            case 8 -> 9502944;
            case 9 -> 29210;
            case 10 -> 0xFFFFFF;
        };
    }

    public static enum Activity implements StringRepresentable
    {
        PARKOUR(21.5, 10.5, 22.0, 90.0f, pl -> {
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            plData.storeInventoryContents();
        }),
        PARKOUR_1(pl -> Activity.findParkourCourse(pl, 1), pl -> InventoryUtil.giveItemTo(pl, AoAItems.RETURN_CRYSTAL)),
        PARKOUR_2(pl -> Activity.findParkourCourse(pl, 2), pl -> InventoryUtil.giveItemTo(pl, AoAItems.RETURN_CRYSTAL)),
        PARKOUR_3(pl -> Activity.findParkourCourse(pl, 3), pl -> InventoryUtil.giveItemTo(pl, AoAItems.RETURN_CRYSTAL)),
        PARKOUR_4(pl -> Activity.findParkourCourse(pl, 4), pl -> InventoryUtil.giveItemTo(pl, AoAItems.RETURN_CRYSTAL)),
        PARKOUR_5(pl -> Activity.findParkourCourse(pl, 5), pl -> InventoryUtil.giveItemTo(pl, AoAItems.RETURN_CRYSTAL)),
        PARKOUR_6(pl -> Activity.findParkourCourse(pl, 6), pl -> InventoryUtil.giveItemTo(pl, AoAItems.RETURN_CRYSTAL)),
        BOSSES(17.5, 502.5, 3.5, 0.0f),
        DUNGEON(6.5, 1501.5, 16.5, -90.0f),
        UTILITY(25.5, 1001.5, 16.0, 90.0f),
        RETURN(pl -> Activity.doReturnPortalTeleport(pl, 16.5, 1501.5, 16.5, 180.0f), pl -> {
            if (!NowhereEvents.isInParkourRegion(pl.blockPosition())) {
                InventoryUtil.clearItems(pl, new ItemLike[]{AoAItems.RETURN_CRYSTAL});
                PlayerUtil.getAdventPlayer((ServerPlayer)pl).storage.returnStoredItems();
                PlayerUtil.resetToDefaultStatus(pl);
            }
        });

        private final Predicate<ServerPlayer> teleportFunction;
        private final Consumer<ServerPlayer> afterTeleportFunction;

        private Activity(Predicate<ServerPlayer> teleportFunction, Consumer<ServerPlayer> afterTeleportFunction) {
            this.teleportFunction = teleportFunction;
            this.afterTeleportFunction = afterTeleportFunction;
        }

        private Activity(double x, double y, double z) {
            this(x, y, z, 0.0f);
        }

        private Activity(double x, double y, double z, float rot) {
            this(x, y, z, rot, null);
        }

        private Activity(double x, double y, @Nullable double z, float rot, Consumer<ServerPlayer> afterTeleportFunction) {
            this(pl -> {
                pl.connection.teleport(x, y, z, rot, pl.getXRot());
                return true;
            }, afterTeleportFunction == null ? pl -> {} : afterTeleportFunction);
        }

        public String getSerializedName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public void teleport(ServerPlayer pl) {
            AoAScheduler.scheduleSyncronisedTask(() -> this.teleportFunction.test(pl), 1);
        }

        public void activate(ServerPlayer pl) {
            AoAScheduler.scheduleSyncronisedTask(() -> {
                if (this.teleportFunction.test(pl)) {
                    this.afterTeleportFunction.accept(pl);
                }
            }, 1);
        }

        private static boolean doReturnPortalTeleport(ServerPlayer pl, double x, double y, double z, float rot) {
            NowhereParkourCourse course;
            if (pl.getY() >= (double)pl.level().getMinBuildHeight() && NowhereEvents.isInParkourRegion(pl.blockPosition()) && pl.isAlive() && BlockPos.betweenClosedStream((AABB)pl.getBoundingBox()).anyMatch(testPos -> pl.level().getBlockState(testPos).is(AoABlocks.NOWHERE_ACTIVITY_PORTAL)) && (course = NowhereParkourCourse.getCourseForPosition(pl.serverLevel(), pl.position())) != null) {
                course.grantRewards(pl);
                NowhereParkourCourse nextCourse = NowhereParkourCourse.getNextCourse(course);
                if (nextCourse != null) {
                    nextCourse.teleportPlayerToCourse(pl);
                    return true;
                }
            }
            pl.connection.teleport(x, y, z, rot, pl.getXRot());
            return true;
        }

        private static boolean findParkourCourse(ServerPlayer pl, int tier) {
            NowhereParkourCourse course = NowhereParkourCourse.getFirstCourseForTier(tier);
            if (course == null) {
                return false;
            }
            course.teleportPlayerToCourse(pl);
            return true;
        }
    }
}

