/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.portal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.portal.PortalBlock;
import net.tslat.aoa3.util.ColourUtil;

public class LboreanPortalBlock
extends PortalBlock {
    public LboreanPortalBlock(BlockBehaviour.Properties properties) {
        super(properties, AoADimensions.LBOREAN, ColourUtil.RGB(0, 173, 216));
    }

    @Override
    public Block getPortalFrame() {
        return Blocks.BUBBLE_CORAL_BLOCK;
    }

    @Override
    public void createPortalBaseAndDecorations(Level level, BlockPos pos, Direction.Axis direction) {
        BlockState border = this.getPortalFrame().defaultBlockState();
        BlockState air = Blocks.AIR.defaultBlockState();
        Vec3 centerPos = Vec3.atBottomCenterOf((Vec3i)pos.above(4));
        for (int x = -4; x <= 4; ++x) {
            for (int y = 7; y >= 0; --y) {
                for (int z = -4; z <= 4; ++z) {
                    BlockState state;
                    BlockPos placePos = pos.offset(x, y, z);
                    double dist = Vec3.atCenterOf((Vec3i)placePos).distanceToSqr(centerPos);
                    if (!(dist <= 16.0) || !level.isInWorldBounds(placePos) || (state = level.getBlockState(placePos)).is(BlockTags.PORTALS) || state.is(border.getBlock())) continue;
                    level.setBlockAndUpdate(placePos, dist <= 9.0 ? air : border);
                }
            }
        }
    }
}

