/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.plant;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.tslat.aoa3.content.block.functional.plant.AoACropBlock;

public abstract class MultiBlockCrop
extends AoACropBlock {
    public static final IntegerProperty HEIGHT_3 = IntegerProperty.create((String)"height", (int)0, (int)2);
    public static IntegerProperty AGE_15 = IntegerProperty.create((String)"age", (int)0, (int)14);
    private final VoxelShape[][] SHAPES;

    public MultiBlockCrop(BlockBehaviour.Properties properties, Supplier<Item> seedItem) {
        super(properties, seedItem);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)this.getHeightProperty(), (Comparable)Integer.valueOf(0)));
        this.SHAPES = new VoxelShape[this.getGrowthHeight()][this.stagesPerBlock()];
        this.populateShapes(this.SHAPES);
    }

    protected abstract void populateShapes(VoxelShape[][] var1);

    public int getGrowthHeight() {
        return 3;
    }

    public int stagesPerBlock() {
        return 5;
    }

    public IntegerProperty getHeightProperty() {
        return HEIGHT_3;
    }

    public IntegerProperty getAgeProperty() {
        return AGE_15;
    }

    public int getMaxAge() {
        return this.getGrowthHeight() * this.stagesPerBlock() - 1;
    }

    public boolean isMaxAgeForPart(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty()) >= this.stagesPerBlock() * (1 + (Integer)state.getValue((Property)this.getHeightProperty())) - 1;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int height = (Integer)state.getValue((Property)this.getHeightProperty());
        int relativeGrowth = Mth.clamp((int)((Integer)state.getValue((Property)this.getAgeProperty()) - ((Integer)state.getValue((Property)this.getHeightProperty()) * (this.stagesPerBlock() - 1) + 1)), (int)0, (int)(this.stagesPerBlock() - 1));
        return this.SHAPES[height][relativeGrowth];
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter world, BlockPos pos) {
        return state.getBlock() == this && this.isMaxAgeForPart(state) || state.getBlock() instanceof FarmBlock;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if ((Integer)state.getValue((Property)this.getAgeProperty()) >= (1 + (Integer)state.getValue((Property)this.getHeightProperty())) * this.stagesPerBlock() && world.getBlockState(pos.above()).getBlock() != this) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, world, pos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (!super.canSurvive(state, world, pos)) {
            return false;
        }
        for (int i = 1; i < this.getGrowthHeight() + 1 && pos.getY() - i >= 0; ++i) {
            BlockState testState = world.getBlockState(pos.below(i));
            if (testState.getBlock() instanceof FarmBlock) {
                return true;
            }
            if (testState.getBlock() == this && this.isMaxAgeForPart(testState)) continue;
            return false;
        }
        return false;
    }

    public void growCrops(Level world, BlockPos pos, BlockState state) {
        this.growDown(world, pos, state);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if (this.isMaxAge(state)) {
            return false;
        }
        if (!this.isMaxAgeForPart(state)) {
            return true;
        }
        while ((state = level.getBlockState(pos = pos.above())).getBlock() == this) {
        }
        return state.isAir();
    }

    protected int getBonemealAgeIncrease(Level pLevel) {
        return 1;
    }

    public void performBonemeal(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        while ((Integer)state.getValue((Property)this.getAgeProperty()) > (1 + (Integer)state.getValue((Property)this.getHeightProperty())) * this.stagesPerBlock() - 1) {
            state = world.getBlockState(pos = pos.above());
            if (state.getBlock() == this) continue;
            return;
        }
        this.growCrops((Level)world, pos, state);
    }

    public boolean isRandomlyTicking(BlockState state) {
        int age = (Integer)state.getValue((Property)this.getAgeProperty());
        if (age == this.getMaxAge()) {
            return false;
        }
        return age <= this.stagesPerBlock() * (1 + (Integer)state.getValue((Property)this.getHeightProperty())) - 1;
    }

    protected void growDown(Level world, BlockPos pos, BlockState currentState) {
        int age = this.getAge(currentState);
        int height = (Integer)currentState.getValue((Property)this.getHeightProperty());
        BlockState agedState = this.getStateForAge(age + 1);
        if (this.isMaxAgeForPart(currentState) && height < this.getGrowthHeight() - 1 && world.isEmptyBlock(pos.above())) {
            world.setBlock(pos.above(), (BlockState)agedState.setValue((Property)this.getHeightProperty(), (Comparable)Integer.valueOf(height + 1)), 3);
        }
        for (int i = 0; i <= height; ++i) {
            BlockPos newPos = pos.below(i);
            if (world.getBlockState(newPos).getBlock() != this) continue;
            world.setBlock(newPos, (BlockState)agedState.setValue((Property)this.getHeightProperty(), (Comparable)Integer.valueOf(height - i)), 3);
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (world.getBlockState(pos.above()).getBlock() == this) {
            return;
        }
        if (!this.isMaxAge(state) && world.getRawBrightness(pos, 0) >= 9) {
            float growthSpeed;
            int age = this.getAge(state);
            int height = (Integer)state.getValue((Property)this.getHeightProperty());
            if (age <= this.stagesPerBlock() * (1 + height) - 1 && CommonHooks.canCropGrow((Level)world, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (growthSpeed = MultiBlockCrop.getGrowthSpeed((BlockState)state, (BlockGetter)world, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
                this.growDown((Level)world, pos, state);
                CommonHooks.fireCropGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getAgeProperty(), this.getHeightProperty()});
    }
}

