/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.block.WaterloggableBlock;
import net.tslat.aoa3.content.block.blockentity.TrophyBlockEntity;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NBTUtil;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class TrophyBlock
extends WaterloggableBlock
implements EntityBlock {
    private static final VoxelShape FULL_AABB = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), Block.box((double)4.5, (double)9.0, (double)4.5, (double)11.5, (double)11.0, (double)11.5)});

    public TrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return FULL_AABB;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrophyBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType != AoABlockEntities.TROPHY.get()) {
            return null;
        }
        if (!level.isClientSide()) {
            return null;
        }
        return (entityLevel, entityPos, entityState, blockEntity) -> TrophyBlockEntity.doClientTick(entityLevel, entityPos, entityState, (TrophyBlockEntity)blockEntity);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (!WorldUtil.canModifyBlock((LevelAccessor)level, pos, (Entity)player, heldStack)) {
            return ItemInteractionResult.FAIL;
        }
        Item item = heldStack.getItem();
        if (item instanceof SpawnEggItem) {
            BlockEntity blockEntity;
            SpawnEggItem spawnEgg = (SpawnEggItem)item;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof TrophyBlockEntity) {
                TrophyBlockEntity trophyBlockEntity = (TrophyBlockEntity)blockEntity;
                trophyBlockEntity.setEntity(spawnEgg.getType(heldStack), true);
                if (!player.getAbilities().instabuild) {
                    heldStack.shrink(1);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        level.getBlockEntity(pos, (BlockEntityType)AoABlockEntities.TROPHY.get()).ifPresent(trophy -> trophy.saveToItem(stack, (HolderLookup.Provider)level.registryAccess()));
        return stack;
    }

    public static Component getDefaultNameWithEntity(Block block, EntityType<?> entityType) {
        return LocaleUtil.getLocaleMessage("block.aoa3." + RegistryUtil.getId(block).getPath() + ".desc", entityType.getDescription());
    }

    public static Component getDefaultNameWithEntity(TrophyData trophyData, String trophyId) {
        return LocaleUtil.getLocaleMessage("block.aoa3." + trophyId + ".desc", trophyData.getEntity().getName());
    }

    public static ItemStack cloneTrophy(ItemStack sourceTrophy, ItemLike destTrophy) {
        ItemStack cloneStack = destTrophy.asItem().getDefaultInstance();
        TrophyData trophyData = (TrophyData)sourceTrophy.get(AoADataComponents.TROPHY_DATA);
        if (trophyData == null) {
            trophyData = new TrophyData(false, new NBTUtil.NBTBuilder<CompoundTag>(new CompoundTag()).putString("id", RegistryUtil.getId(EntityType.ITEM).toString()).build());
        }
        cloneStack.set(AoADataComponents.TROPHY_DATA, (Object)trophyData);
        cloneStack.set(DataComponents.ITEM_NAME, (Object)TrophyBlock.getDefaultNameWithEntity(trophyData, RegistryUtil.getId(cloneStack).getPath()));
        return cloneStack;
    }

    public static boolean isOriginal(ItemStack stack) {
        TrophyData trophyData = (TrophyData)stack.get(AoADataComponents.TROPHY_DATA);
        return trophyData != null && trophyData.isOriginalTrophy();
    }

    public record TrophyData(boolean isOriginalTrophy, CompoundTag entityData, Function<TrophyData, Entity> cachedEntity) {
        public static final Codec<TrophyData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("is_original").forGetter(TrophyData::isOriginalTrophy), (App)CompoundTag.CODEC.fieldOf("entity_data").forGetter(TrophyData::entityData)).apply((Applicative)builder, TrophyData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TrophyData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, TrophyData::isOriginalTrophy, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, TrophyData::entityData, TrophyData::new);

        public TrophyData(boolean isOriginalTrophy, CompoundTag entityData) {
            this(isOriginalTrophy, entityData, new Function<TrophyData, Entity>(){
                Entity value = null;

                @Override
                public Entity apply(TrophyData trophyData) {
                    if (this.value == null) {
                        this.value = trophyData.createEntity();
                    }
                    return this.value;
                }
            });
        }

        public TrophyData(boolean isOriginalTrophy, EntityType<?> entity) {
            this(isOriginalTrophy, new NBTUtil.NBTBuilder<CompoundTag>(new CompoundTag()).putString("id", RegistryUtil.getId(entity).toString()).build());
        }

        public Entity getEntity() {
            return this.cachedEntity.apply(this);
        }

        @Nullable
        public EntityType<?> getEntityType() {
            return (EntityType)ResourceLocation.read((String)this.entityData.getString("id")).mapOrElse(AoARegistries.ENTITIES::getEntry, err -> null);
        }

        private Entity createEntity() {
            Level level = FMLEnvironment.dist == Dist.CLIENT ? ClientOperations.getLevel() : WorldUtil.getServer().overworld();
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)this.entityData(), (Level)level, Function.identity());
            if (entity == null) {
                entity = new ItemEntity(level, 0.0, 0.0, 0.0, Items.AIR.getDefaultInstance());
            }
            entity.tickCount = 1;
            return entity;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TrophyData)) {
                return false;
            }
            TrophyData otherTrophy = (TrophyData)obj;
            if (this.isOriginalTrophy ^ otherTrophy.isOriginalTrophy) {
                return false;
            }
            return Objects.equals(this.entityData, otherTrophy.entityData);
        }
    }
}

