/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.misc;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.block.functional.misc.TrophyBlock;
import net.tslat.aoa3.content.item.misc.summoning.BossTokenItem;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.EntitySpawningUtil;
import org.jetbrains.annotations.Nullable;

public class GoldTrophyBlock
extends TrophyBlock
implements BossTokenItem {
    private static final Supplier<Map<EntityType<?>, EntityType<?>>> TYPE_SUBSTITUTES = Suppliers.memoize(() -> (Map)Util.make((Object)new Reference2ReferenceArrayMap(), map -> {
        map.put((Object)((EntityType)AoAMonsters.SMASH.value()), (Object)((EntityType)AoAMonsters.ELITE_SMASH.value()));
        map.put((Object)((EntityType)AoAMonsters.KING_BAMBAMBAM.value()), (Object)((EntityType)AoAMonsters.ELITE_KING_BAMBAMBAM.value()));
        map.put((Object)((EntityType)AoAMonsters.NETHENGEIC_WITHER.value()), (Object)((EntityType)AoAMonsters.ELITE_NETHENGEIC_WITHER.value()));
        map.put((Object)((EntityType)AoAMonsters.SKELETRON.value()), (Object)((EntityType)AoAMonsters.ELITE_SKELETRON.value()));
        map.put((Object)((EntityType)AoAMonsters.TYROSAUR.value()), (Object)((EntityType)AoAMonsters.ELITE_TYROSAUR.value()));
    }));

    public GoldTrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public Entity spawnBoss(ServerLevel level, Vec3 position, ItemStack itemStack, int playerCount) {
        Object boss = EntitySpawningUtil.spawnEntity(level, this.getEntityType(itemStack), position, MobSpawnType.TRIGGERED);
        if (playerCount > 1 && boss instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)boss;
            AttributeUtil.applyPermanentModifier(entity, (Holder<Attribute>)Attributes.MAX_HEALTH, this.getPerPlayerHealthBuff(playerCount));
            entity.setHealth(entity.getMaxHealth());
        }
        return boss;
    }

    @Nullable
    public EntityType<?> getEntityType(ItemStack stack) {
        TrophyBlock.TrophyData trophyData = (TrophyBlock.TrophyData)stack.get(AoADataComponents.TROPHY_DATA);
        if (trophyData == null || !trophyData.isOriginalTrophy()) {
            return null;
        }
        return TYPE_SUBSTITUTES.get().getOrDefault(trophyData.getEntityType(), trophyData.getEntityType());
    }
}

