/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.light;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class LampBlock
extends RedstoneLampBlock {
    public static final BooleanProperty TOGGLEABLE = BooleanProperty.create((String)"toggleable");

    public LampBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)TOGGLEABLE, (Comparable)Boolean.valueOf(true)));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean lit;
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)TOGGLEABLE)).booleanValue() && (lit = ((Boolean)state.getValue((Property)LIT)).booleanValue()) != world.hasNeighborSignal(pos)) {
            if (lit) {
                world.scheduleTick(pos, (Block)this, 4);
            } else {
                world.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)TOGGLEABLE)).booleanValue() && ((Boolean)state.getValue((Property)LIT)).booleanValue() && !world.hasNeighborSignal(pos)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT}).add(new Property[]{TOGGLEABLE});
    }
}

