/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.fluid;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Tar
extends LiquidBlock {
    public Tar(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier.get(), properties);
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.DAMAGE_FIRE;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return PathType.DAMAGE_FIRE;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        PathfinderMob mob;
        float sizeSpeedMod = Mth.clamp((float)(1.0f / (2.0f / (entity.getBbWidth() * entity.getBbHeight()))), (float)0.35f, (float)1.0f);
        if (entity instanceof PathfinderMob && (mob = (PathfinderMob)entity).getNavigation().getNodeEvaluator() instanceof FlyNodeEvaluator) {
            sizeSpeedMod = Math.min(1.0f, sizeSpeedMod * 1.5f);
        }
        entity.makeStuckInBlock(state, new Vec3((double)sizeSpeedMod, (double)sizeSpeedMod, (double)sizeSpeedMod));
        entity.igniteForSeconds(2.0f);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextFloat() < 0.01f && level.getBlockState(pos.above()).isAir()) {
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + random.nextFloat()), 0.0, (double)0.05f, 0.0);
        }
    }
}

