/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.altar;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.altar.BossAltarBlock;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class VinocorneShrine
extends BossAltarBlock {
    public VinocorneShrine(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected boolean checkActivationConditions(Player player, InteractionHand hand, BlockState state, BlockPos pos) {
        return WorldUtil.isWorld(player.level(), AoADimensions.GARDENCIA) && player.level().getBlockState(pos.above()).canBeReplaced();
    }

    @Override
    protected void doActivationEffect(Player player, InteractionHand hand, BlockState state, BlockPos blockPos) {
        player.level().setBlockAndUpdate(blockPos.above(), ((Block)AoABlocks.LIVING_GROWTH.get()).defaultBlockState());
        player.level().scheduleTick(blockPos.above(), (Block)AoABlocks.LIVING_GROWTH.get(), 40);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(world, player, pos, state, te, stack);
        if (world.getBlockState(pos.above()).getBlock() == AoABlocks.LIVING_GROWTH.get()) {
            world.setBlockAndUpdate(pos.above(), Blocks.AIR.defaultBlockState());
        }
    }

    @Override
    protected Item getActivationItem() {
        return (Item)AoAItems.PETALS.get();
    }
}

