/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.altar;

import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.altar.BossAltarBlock;
import net.tslat.aoa3.scheduling.async.CreepSpawnTask;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class CreepAltar
extends BossAltarBlock {
    public CreepAltar(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void doActivationEffect(Player player, InteractionHand hand, BlockState state, BlockPos blockPos) {
        double centerX = (double)blockPos.getX() + 0.5;
        double centerZ = (double)blockPos.getZ() + 0.5;
        Level world = player.level();
        if (world.getBlockState(blockPos.north()).getBlock() == this) {
            centerZ -= 0.5;
        }
        if (world.getBlockState(blockPos.south()).getBlock() == this) {
            centerZ += 0.5;
        }
        if (world.getBlockState(blockPos.east()).getBlock() == this) {
            centerX += 0.5;
        }
        if (world.getBlockState(blockPos.west()).getBlock() == this) {
            centerX -= 0.5;
        }
        new CreepSpawnTask(world, centerX, blockPos.getY() + 1, centerZ, RandomUtil.randomNumberUpTo((int)4)).schedule(1, TimeUnit.SECONDS);
    }

    @Override
    protected boolean checkActivationConditions(Player player, InteractionHand hand, BlockState state, BlockPos pos) {
        return WorldUtil.isWorld(player.level(), AoADimensions.CREEPONIA);
    }

    @Override
    protected Item getActivationItem() {
        return (Item)AoAItems.EXPLOSIVE_GEMS.get();
    }
}

