/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.altar;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import org.jetbrains.annotations.Nullable;

public abstract class BossAltarBlock
extends Block {
    public BossAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.getActivationItem() != null && stack.getItem() != this.getActivationItem()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            if (!level.isClientSide) {
                PlayerUtil.notifyPlayer(player, (Component)Component.translatable((String)LocaleUtil.createFeedbackLocaleKey("spawnBoss.difficultyFail")));
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player instanceof ServerPlayer && (this.getActivationItem() == null || stack.getItem() == this.getActivationItem()) && this.checkActivationConditions(player, hand, state, pos)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.doActivationEffect(player, hand, state, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    protected abstract Item getActivationItem();

    protected abstract void doActivationEffect(Player var1, InteractionHand var2, BlockState var3, BlockPos var4);

    protected boolean checkActivationConditions(Player player, InteractionHand hand, BlockState state, BlockPos pos) {
        return true;
    }

    protected void sendSpawnMessage(Player player, MutableComponent msg, BlockPos pos) {
        PlayerUtil.messageAllPlayersInRange((Component)msg, player.level(), pos, 50);
    }
}

