/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.decoration.banner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.content.block.decoration.banner.BannerBlock;
import org.jetbrains.annotations.Nullable;

public class BannerExtension
extends Block
implements SimpleWaterloggedBlock {
    public BannerExtension(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(BannerBlock.TYPE, (Comparable)((Object)BannerBlock.BannerType.MOUNTED))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos bannerPos = state.getValue(BannerBlock.TYPE) == BannerBlock.BannerType.MOUNTED ? pos.above() : pos.below();
        BlockState banner = world.getBlockState(bannerPos);
        world.setBlock(bannerPos, Blocks.AIR.defaultBlockState(), 35);
        world.levelEvent(player, 2001, bannerPos, Block.getId((BlockState)banner));
        if (!world.isClientSide() && !player.isCreative()) {
            BannerExtension.dropResources((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            BannerExtension.dropResources((BlockState)banner, (Level)world, (BlockPos)bannerPos, null, (Entity)player, (ItemStack)player.getMainHandItem());
        }
        return state;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        int n;
        if (state.getValue(BannerBlock.TYPE) == BannerBlock.BannerType.MOUNTED) {
            BlockState banner = world.getBlockState(pos.above());
            n = banner.getBlock().getLightEmission(banner, world, pos.above());
        } else {
            BlockState banner = world.getBlockState(pos.below());
            n = banner.getBlock().getLightEmission(banner, world, pos.below());
        }
        return n;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (state.getValue(BannerBlock.TYPE) == BannerBlock.BannerType.MOUNTED) {
            if (!(world.getBlockState(pos.above()).getBlock() instanceof BannerBlock)) {
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        } else if (!(world.getBlockState(pos.below()).getBlock() instanceof BannerBlock)) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.above()).getBlock() instanceof BannerBlock || world.getBlockState(pos.below()).getBlock() instanceof BannerBlock;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue(BannerBlock.TYPE) == BannerBlock.BannerType.MOUNTED) {
            return world.getBlockState(pos.above()).getShape(world, pos.below());
        }
        return world.getBlockState(pos.below()).getShape(world, pos.above());
    }

    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BannerBlock.TYPE, HorizontalDirectionalBlock.FACING, BlockStateProperties.WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockPos bannerPos = state.getValue(BannerBlock.TYPE) == BannerBlock.BannerType.MOUNTED ? pos.above() : pos.below();
        BlockState bannerBlock = level.getBlockState(bannerPos);
        return bannerBlock.getBlock().getCloneItemStack(level, bannerPos, bannerBlock);
    }
}

