/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.decoration.banner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.util.EntityUtil;
import org.jetbrains.annotations.Nullable;

public class BannerBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<BannerType> TYPE = EnumProperty.create((String)"type", BannerType.class);
    private static final VoxelShape MOUNTED_NORTH_SHAPE = Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.15625));
    private static final VoxelShape MOUNTED_SOUTH_SHAPE = Shapes.create((AABB)new AABB(0.0, 0.0, 0.84375, 1.0, 1.0, 1.0));
    private static final VoxelShape MOUNTED_EAST_SHAPE = Shapes.create((AABB)new AABB(0.84375, 0.0, 0.0, 1.0, 1.0, 1.0));
    private static final VoxelShape MOUNTED_WEST_SHAPE = Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 0.15625, 1.0, 1.0));
    private static final VoxelShape STANDING_NORTH_SHAPE = Shapes.create((AABB)new AABB(0.1875, 0.0, 0.453125, 0.8125, 1.0, 0.609375));
    private static final VoxelShape STANDING_SOUTH_SHAPE = Shapes.create((AABB)new AABB(0.1875, 0.0, 0.390625, 0.8125, 1.0, 0.546875));
    private static final VoxelShape STANDING_EAST_SHAPE = Shapes.create((AABB)new AABB(0.390625, 0.0, 0.1875, 0.546875, 1.0, 0.8125));
    private static final VoxelShape STANDING_WEST_SHAPE = Shapes.create((AABB)new AABB(0.453125, 0.0, 0.1875, 0.609375, 1.0, 0.8125));

    public BannerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)BannerType.MOUNTED))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!world.isClientSide()) {
            if (state.getValue(TYPE) == BannerType.MOUNTED) {
                world.setBlockAndUpdate(pos.below(), (BlockState)((BlockState)((BlockState)((Block)AoABlocks.BANNER_EXTENSION.get()).defaultBlockState().setValue(TYPE, (Comparable)((Object)BannerType.MOUNTED))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.below()).getType() == Fluids.WATER)));
            } else {
                world.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)((BlockState)((Block)AoABlocks.BANNER_EXTENSION.get()).defaultBlockState().setValue(TYPE, (Comparable)((Object)BannerType.STANDING))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.above()).getType() == Fluids.WATER)));
            }
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (state.getValue(TYPE) == BannerType.MOUNTED) {
            world.setBlockAndUpdate(pos.below(), Blocks.AIR.defaultBlockState());
        } else {
            world.setBlockAndUpdate(pos.above(), Blocks.AIR.defaultBlockState());
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue(TYPE) == BannerType.MOUNTED) {
            Direction mountedFace = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
            return BannerBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.relative(mountedFace), (Direction)mountedFace.getOpposite()) && world.getBlockState(pos.below()).canBeReplaced();
        }
        return world.getBlockState(pos.above()).canBeReplaced();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return switch (context.getClickedFace()) {
            default -> throw new MatchException(null, null);
            case Direction.SOUTH, Direction.NORTH, Direction.WEST, Direction.EAST -> (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)BannerType.MOUNTED))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
            case Direction.UP, Direction.DOWN -> (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)BannerType.STANDING))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)EntityUtil.getDirectionFacing((Entity)context.getPlayer(), true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean mounted = state.getValue(TYPE) == BannerType.MOUNTED;
        return switch ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.SOUTH -> {
                if (mounted) {
                    yield MOUNTED_SOUTH_SHAPE;
                }
                yield STANDING_SOUTH_SHAPE;
            }
            case Direction.EAST -> {
                if (mounted) {
                    yield MOUNTED_EAST_SHAPE;
                }
                yield STANDING_EAST_SHAPE;
            }
            case Direction.WEST -> {
                if (mounted) {
                    yield MOUNTED_WEST_SHAPE;
                }
                yield STANDING_WEST_SHAPE;
            }
            case Direction.NORTH, Direction.UP, Direction.DOWN -> mounted ? MOUNTED_NORTH_SHAPE : STANDING_NORTH_SHAPE;
        };
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.getValue(TYPE) == BannerType.MOUNTED) {
            if (!world.getBlockState(pos.relative((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING))).isSolid()) {
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        } else if (!world.getBlockState(pos.below()).isSolid()) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, HorizontalDirectionalBlock.FACING, BlockStateProperties.WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public static enum BannerType implements StringRepresentable
    {
        MOUNTED("mounted"),
        STANDING("standing");

        private final String name;

        private BannerType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

