/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.menu.ImbuingChamberMenu;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.content.block.blockentity.GenericContainerBlockEntity;
import net.tslat.aoa3.content.item.misc.AspectFocusItem;
import net.tslat.aoa3.library.object.GenericItemStackHandler;

public class ImbuingChamberBlockEntity
extends GenericContainerBlockEntity {
    private static final Component DEFAULT_NAME = Component.translatable((String)"container.aoa3.imbuing_chamber");
    private final ImbuingChamberItemHandler itemHandler = new ImbuingChamberItemHandler();

    public ImbuingChamberBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AoABlockEntities.IMBUING_CHAMBER.get(), pos, state);
    }

    public int getContainerSize() {
        return 7;
    }

    public GenericItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public NonNullList<ItemStack> getItems() {
        return this.getItemHandler().getAllStacks();
    }

    public Component getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    public CompoundTag saveContents(HolderLookup.Provider holderLookup) {
        return this.getItemHandler().serializeNBT(holderLookup);
    }

    @Override
    public void loadContents(HolderLookup.Provider holderLookup, CompoundTag compound) {
        this.getItemHandler().deserializeNBT(holderLookup, compound);
    }

    @Override
    public void clearContent() {
        this.getItemHandler().clear();
    }

    @Override
    public void setItemNoUpdate(int slot, ItemStack stack) {
        this.getItemHandler().setStackInSlot(slot, stack);
    }

    public ImbuingChamberMenu createMenu(int containerId, final Inventory playerInventory) {
        ImbuingChamberMenu container = new ImbuingChamberMenu(containerId, playerInventory, ContainerLevelAccess.create((Level)playerInventory.player.level(), (BlockPos)this.getBlockPos())){

            protected void clearContainer(Player player, Container container) {
                ImbuingChamberBlockEntity.this.setItems(((ImbuingChamberMenu.ImbuingInventory)((Object)this.getInventory())).getItems());
                ((ImbuingChamberMenu.ImbuingInventory)((Object)this.getInventory())).clearContent();
                super.clearContainer(player, container);
            }

            @Override
            public void slotsChanged(Container inventory) {
                if (playerInventory.player.containerMenu == this) {
                    ImbuingChamberBlockEntity.this.setItems(((ImbuingChamberMenu.ImbuingInventory)((Object)this.getInventory())).getItems());
                }
                super.slotsChanged(inventory);
            }
        };
        NonNullList<ItemStack> contents = this.getItems();
        for (int i = 0; i < 6 && i < contents.size(); ++i) {
            ((ImbuingChamberMenu.ImbuingInventory)((Object)container.getInventory())).setItem(i, (ItemStack)contents.get(i));
        }
        container.getOutputSlot().set((ItemStack)contents.get(6));
        return container;
    }

    public static class ImbuingChamberItemHandler
    extends GenericItemStackHandler {
        ImbuingChamberItemHandler() {
            super(7);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot > 0 && slot < 6) {
                return stack.getItem() instanceof AspectFocusItem;
            }
            return true;
        }
    }
}

