/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class GenericContainerBlockEntity
extends BaseContainerBlockEntity {
    public GenericContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract IItemHandler getItemHandler();

    public abstract CompoundTag saveContents(HolderLookup.Provider var1);

    public abstract void loadContents(HolderLookup.Provider var1, CompoundTag var2);

    public abstract void clearContent();

    public abstract void setItemNoUpdate(int var1, ItemStack var2);

    public void setItem(int slot, ItemStack stack) {
        this.setItemNoUpdate(slot, stack);
        this.markUpdated();
    }

    public void dropContents() {
        Vec3 pos = Vec3.atCenterOf((Vec3i)this.getBlockPos());
        for (ItemStack stack : this.getItems()) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, pos.x, pos.y, pos.z, stack));
        }
        this.clearContent();
    }

    protected final void setItems(NonNullList<ItemStack> items) {
        this.setItems((List<ItemStack>)items);
    }

    protected void setItems(List<ItemStack> items) {
        this.clearContent();
        int maxSize = this.getContainerSize();
        for (int i = 0; i < maxSize && i < items.size(); ++i) {
            this.setItemNoUpdate(i, items.get(i));
        }
        this.markUpdated();
    }

    public void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider holderLookup) {
        CompoundTag compound = super.getUpdateTag(holderLookup);
        compound.put("Contents", (Tag)this.saveContents(holderLookup));
        return compound;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider holderLookup) {
        super.saveAdditional(compound, holderLookup);
        compound.put("Contents", (Tag)this.saveContents(holderLookup));
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider holderLookup) {
        super.loadAdditional(compound, holderLookup);
        this.loadContents(holderLookup, compound);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CustomName");
        tag.remove("Lock");
        tag.remove("Contents");
    }
}

